/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class MapPipe<S, T>
implements Pipe<T> {
    private final Pipe<S> input;
    private final FailableFunction<? super S, T, PipeException> mapFunction;
    private T next;

    public MapPipe(Pipe<S> input, FailableFunction<? super S, T, PipeException> mapFunction) {
        this.input = input;
        this.mapFunction = mapFunction;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    private void prepareNext() throws PipeException, InterruptedException {
        S nextFromIn = this.input.next();
        this.next = nextFromIn == null ? null : this.mapFunction.apply(nextFromIn);
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }
}

