/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.pipes.exceptions.OutOfOrderPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public abstract class MultiSortedBasePipe<T>
implements Pipe<T> {
    private final List<? extends Pipe<T>> pipes;
    private final BitSet activePipes;
    private final PriorityQueue<LabeledPipe<T>> queue;
    private final Comparator<? super T> comparator;
    private T next;

    public MultiSortedBasePipe(List<? extends Pipe<T>> inputPipes, Comparator<? super T> comparator) {
        this.comparator = comparator;
        this.pipes = inputPipes;
        this.activePipes = new BitSet(inputPipes.size());
        this.queue = new PriorityQueue(Math.max(inputPipes.size(), 1), (p1, p2) -> comparator.compare((Object)p1.peekNext(), (Object)p2.peekNext()));
    }

    @SafeVarargs
    public MultiSortedBasePipe(Comparator<? super T> comparator, Pipe<T> ... inputPipes) {
        this(Arrays.asList(inputPipes), comparator);
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        for (int i = 0; i < this.pipes.size(); ++i) {
            Pipe<T> pipe = this.pipes.get(i);
            pipe.start();
            T next = pipe.peek();
            if (next == null) continue;
            LabeledPipe<T> p = new LabeledPipe<T>(pipe, i);
            p.setNext(next);
            this.queue.add(p);
            this.activePipes.set(i);
        }
        if (this.canTerminate(this.activePipes)) {
            this.queue.clear();
        }
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        FileUtils.close(this.pipes);
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    protected abstract boolean shouldOutput(T var1, BitSet var2);

    protected abstract boolean canTerminate(BitSet var1);

    protected List<? extends Pipe<T>> getInputPipes() {
        return this.pipes;
    }

    private void prepareNext() throws PipeException, InterruptedException {
        LabeledPipe<T> labeledPipe = this.queue.peek();
        if (labeledPipe == null) {
            this.next = null;
            return;
        }
        T prev = this.next;
        Object item = labeledPipe.peekNext();
        BitSet pipesSeen = new BitSet(this.pipes.size());
        boolean shouldTerminate = false;
        while (true) {
            if (labeledPipe != null && this.comparator.compare(labeledPipe.pipe.peek(), item) == 0) {
                pipesSeen.set(labeledPipe.id);
                labeledPipe.pipe.next();
                this.queue.poll();
                Object peeked = labeledPipe.pipe.peek();
                if (peeked != null) {
                    labeledPipe.setNext(peeked);
                    this.queue.add(labeledPipe);
                } else {
                    this.activePipes.clear(labeledPipe.id);
                    shouldTerminate = this.canTerminate(this.activePipes);
                }
                labeledPipe = this.queue.peek();
                continue;
            }
            if (shouldTerminate) {
                this.queue.clear();
            }
            if (prev != null && this.comparator.compare(item, prev) <= 0) {
                throw new OutOfOrderPipeException("One or more of the streams isn't sorted: " + prev + " vs " + item);
            }
            if (this.shouldOutput(item, pipesSeen)) {
                this.next = item;
                break;
            }
            if (labeledPipe == null) {
                this.next = null;
                break;
            }
            pipesSeen.clear();
            prev = item;
            item = labeledPipe.pipe.peek();
        }
    }

    private static class LabeledPipe<C> {
        private final Pipe<C> pipe;
        private final int id;
        private C next;

        public LabeledPipe(Pipe<C> pipe, int id) {
            this.pipe = pipe;
            this.id = id;
        }

        public void setNext(C next) {
            this.next = next;
        }

        public C peekNext() {
            return this.next;
        }
    }
}

