/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import java.util.function.Consumer;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class ProgressPipe<T>
implements Pipe<T> {
    private final Pipe<T> input;
    private final Consumer<Integer> callback;
    private final int sampleRate;
    private int countSinceLastSample;
    private T next;
    private int progressPct;

    public ProgressPipe(Pipe<T> input, int sampleRate, Consumer<Integer> callback) {
        this.input = input;
        this.sampleRate = sampleRate;
        this.callback = callback;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        this.callback.accept(0);
        this.prepareNext();
    }

    private void prepareNext() throws PipeException, InterruptedException {
        this.next = this.input.next();
        if (this.next == null) {
            this.update(100);
        } else if (++this.countSinceLastSample == this.sampleRate) {
            this.update((int)(100.0f * this.input.getProgress()));
            this.countSinceLastSample = 0;
        }
    }

    private void update(int newProgressPct) {
        if (newProgressPct > this.progressPct) {
            this.progressPct = newProgressPct;
            this.callback.accept(newProgressPct);
        }
    }

    @Override
    public float getProgress() {
        return this.input.getProgress();
    }
}

