/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.pipes.exceptions.OutOfOrderPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.utils.PipeUtils;

public class SortedMergePipe<T>
implements Pipe<T> {
    private final List<? extends Pipe<T>> pipes;
    private final PriorityQueue<LabeledPipe<T>> queue;
    private final Comparator<? super T> comparator;
    private T next;

    public SortedMergePipe(List<? extends Pipe<T>> inputPipes, Comparator<? super T> comparator) {
        this.comparator = comparator;
        this.pipes = inputPipes;
        this.queue = new PriorityQueue(Math.max(inputPipes.size(), 1), (p1, p2) -> comparator.compare((Object)p1.peek(), (Object)p2.peek()));
    }

    @SafeVarargs
    public SortedMergePipe(Comparator<? super T> comparator, Pipe<T> ... inputPipes) {
        this(Arrays.asList(inputPipes), comparator);
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        for (Pipe<T> pipe : this.pipes) {
            pipe.start();
            T next = pipe.peek();
            if (next == null) continue;
            LabeledPipe<T> p = new LabeledPipe<T>(pipe);
            p.fetchNext();
            this.queue.add(p);
        }
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        FileUtils.close(this.pipes);
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    private void prepareNext() throws PipeException, InterruptedException {
        LabeledPipe<T> labeledPipe = this.queue.poll();
        if (labeledPipe == null) {
            this.next = null;
            return;
        }
        T item = labeledPipe.peek();
        labeledPipe.fetchNext();
        if (labeledPipe.peek() != null) {
            this.queue.add(labeledPipe);
        }
        if (this.next != null && this.comparator.compare(item, this.next) < 0) {
            throw new OutOfOrderPipeException("One or more of the streams isn't sorted: " + this.next + " vs " + item);
        }
        this.next = item;
    }

    @Override
    public float getProgress() {
        return PipeUtils.getMinProgress(this.pipes);
    }

    private static class LabeledPipe<C> {
        private final Pipe<C> pipe;
        private C next;

        public LabeledPipe(Pipe<C> pipe) {
            this.pipe = pipe;
        }

        public void fetchNext() throws PipeException, InterruptedException {
            this.next = this.pipe.next();
        }

        public C peek() {
            return this.next;
        }
    }
}

