/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class TopKPipe<T>
implements Pipe<T> {
    private final Pipe<T> input;
    private final PriorityQueue<T> heap;
    private final int k;
    private List<T> results;
    private int pos;

    public TopKPipe(Pipe<T> input, int k, Comparator<? super T> comparator) {
        this.input = input;
        this.heap = new PriorityQueue<T>(k, comparator);
        this.k = k;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        int i;
        T item;
        this.input.start();
        while ((item = this.input.next()) != null) {
            this.heap.add(item);
            if (this.heap.size() <= this.k) continue;
            this.heap.poll();
        }
        int count = this.heap.size();
        this.results = new ArrayList<T>(count);
        for (i = 0; i < count; ++i) {
            this.results.add(null);
        }
        for (i = 0; i < count; ++i) {
            this.results.set(count - i - 1, this.heap.poll());
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        if (this.pos == this.results.size()) {
            return null;
        }
        return this.results.get(this.pos++);
    }

    @Override
    public T peek() {
        return this.results.get(this.pos);
    }

    @Override
    public float getProgress() {
        return 1.0f;
    }
}

