/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter.reduct;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.serialization.CodecFactory;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.CompoundPipe;
import org.pipecraft.pipes.sync.inter.ConcatPipe;
import org.pipecraft.pipes.sync.inter.reduct.ReductorConfig;
import org.pipecraft.pipes.sync.source.BinInputReaderPipe;
import org.pipecraft.pipes.sync.source.CollectionReaderPipe;
import org.pipecraft.pipes.terminal.SharderByHashPipe;
import org.pipecraft.pipes.utils.PipeSupplier;

public class HashReductorPipe<I, O>
extends CompoundPipe<O> {
    private final Pipe<I> input;
    private final CodecFactory<I> inputCodec;
    private final int partitionCount;
    private final ReductorConfig<I, Object, Object, O> reductorConfig;
    private final File tmpFolder;
    private File tmpSubFolder;

    public HashReductorPipe(Pipe<I> input, CodecFactory<I> inputCodec, int partitionCount, File tmpFolder, ReductorConfig<I, ?, ?, O> reductorConfig) {
        this.input = input;
        this.inputCodec = inputCodec;
        this.partitionCount = partitionCount;
        this.tmpFolder = tmpFolder;
        this.reductorConfig = reductorConfig;
    }

    @Override
    protected Pipe<O> createPipeline() throws PipeException, InterruptedException {
        this.tmpSubFolder = null;
        try {
            this.tmpSubFolder = FileUtils.createTempFolder("hashReductor", this.tmpFolder);
            try (SharderByHashPipe<I> sharder = new SharderByHashPipe<I>(this.input, this.inputCodec, this.reductorConfig.getDiscriminator(), String::valueOf, this.partitionCount, this.tmpSubFolder, new FileWriteOptions().temp(true));){
                sharder.start();
            }
            ArrayList outputPipes = new ArrayList();
            for (int shard = 0; shard < this.partitionCount; ++shard) {
                File file = new File(this.tmpSubFolder, String.valueOf(shard));
                if (!file.exists()) continue;
                PipeSupplier supplier = () -> {
                    try (BinInputReaderPipe<I> fileReaderP = new BinInputReaderPipe<I>(file, this.inputCodec);){
                        I item;
                        fileReaderP.start();
                        HashMap<Object, Object> map = new HashMap<Object, Object>();
                        while ((item = fileReaderP.next()) != null) {
                            Object family = this.reductorConfig.getDiscriminator().apply(item);
                            Object intermediate = map.computeIfAbsent(family, k -> this.reductorConfig.getAggregatorCreator().apply(family));
                            this.reductorConfig.getAggregationLogic().accept(intermediate, item);
                        }
                        ArrayList<O> shardOutput = new ArrayList<O>();
                        for (Object intermediate : map.values()) {
                            shardOutput.add(this.reductorConfig.getPostProcessor().apply(intermediate));
                        }
                        CollectionReaderPipe collectionReaderPipe = new CollectionReaderPipe(shardOutput);
                        return collectionReaderPipe;
                    }
                };
                outputPipes.add(supplier);
            }
            return new ConcatPipe(outputPipes);
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        FileUtils.deleteFiles(this.tmpSubFolder);
    }
}

