/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.inter.reduct;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.exceptions.ExcessiveResourcesUsagePipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.reduct.ReductorConfig;
import org.pipecraft.pipes.sync.inter.reduct.SequenceReductorPipe;

public class ListReductorPipe<S, T>
extends SequenceReductorPipe<S, T> {
    public ListReductorPipe(Pipe<S> input, FailableFunction<S, ?, PipeException> discriminator, Function<List<S>, T> postProcessor, int groupSizeLimit, GroupSizeLimitPolicy sizeLimitPolicy) {
        super(input, ReductorConfig.builder().discriminator(discriminator).aggregatorCreator(v -> new ArrayList()).aggregationLogic((list, v) -> ListReductorPipe.aggregate(list, v, groupSizeLimit, sizeLimitPolicy)).postProcessor(postProcessor).build());
    }

    public ListReductorPipe(Pipe<S> input, FailableFunction<S, ?, PipeException> discriminator, Function<List<S>, T> postProcessor) {
        this(input, discriminator, postProcessor, 0, null);
    }

    private static <V> void aggregate(List<V> list, V v, int groupSizeLimit, GroupSizeLimitPolicy sizeLimitPolicy) throws PipeException {
        if (groupSizeLimit > 0 && list.size() == groupSizeLimit) {
            switch (sizeLimitPolicy) {
                case TRUNCATE: {
                    return;
                }
                case FAIL: {
                    throw new ExcessiveResourcesUsagePipeException("Sequence reductor encountered more than " + groupSizeLimit + " items in the same group.");
                }
            }
        }
        list.add(v);
    }

    public static enum GroupSizeLimitPolicy {
        TRUNCATE,
        FAIL;

    }
}

