/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.pipecraft.infra.concurrent.FailableInterruptibleSupplier;
import org.pipecraft.infra.io.Compression;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.serialization.DecoderFactory;
import org.pipecraft.pipes.serialization.ItemDecoder;
import org.pipecraft.pipes.sync.source.InputStreamPipe;

public class BinInputReaderPipe<T>
extends InputStreamPipe<T> {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final FailableInterruptibleSupplier<SizedInputStream, IOException> isCreator;
    private final DecoderFactory<T> decoderFactory;
    private final FileReadOptions readOptions;
    private ItemDecoder<T> decoder;
    private T next;

    public BinInputReaderPipe(FailableInterruptibleSupplier<SizedInputStream, IOException> isCreator, DecoderFactory<T> decoderFactory, int bufferSize, Compression compression) {
        super(0, Compression.NONE);
        this.isCreator = isCreator;
        this.readOptions = new FileReadOptions().buffer(bufferSize).setCompression(compression);
        this.decoderFactory = decoderFactory;
    }

    public BinInputReaderPipe(InputStream is, DecoderFactory<T> decoderFactory, int bufferSize, long sizeBytes, Compression compression) {
        this(() -> new SizedInputStream(is, sizeBytes), decoderFactory, bufferSize, compression);
    }

    public BinInputReaderPipe(SizedInputStream is, DecoderFactory<T> decoderFactory, FileReadOptions readOptions) {
        this(() -> is, decoderFactory, readOptions.getBufferSize(), readOptions.getCompression());
    }

    public BinInputReaderPipe(File inputFile, FileReadOptions options, DecoderFactory<T> decoderFactory) {
        this(() -> new SizedInputStream(new FileInputStream(inputFile), inputFile.length()), decoderFactory, options.getBufferSize(), options.getCompression());
    }

    public BinInputReaderPipe(File inputFile, DecoderFactory<T> decoderFactory) {
        this(() -> new SizedInputStream(new FileInputStream(inputFile), inputFile.length()), decoderFactory, 8192, Compression.NONE);
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    protected SizedInputStream createInputStream() throws IOException, InterruptedException {
        return this.isCreator.get();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        super.start();
        try {
            this.decoder = this.decoderFactory.newDecoder(this.getInputStream(), this.readOptions);
            this.prepareNext();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    private void prepareNext() throws PipeException {
        try {
            this.next = this.decoder.decode();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

