/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.pipecraft.infra.io.Compression;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.infra.io.ThreadSafeCountingInputStream;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public abstract class InputStreamPipe<T>
implements Pipe<T> {
    private final int bufferSizeBytes;
    private final Compression compression;
    private ThreadSafeCountingInputStream inputByteCounterStream;
    private InputStream is;
    private Long size;

    public InputStreamPipe(int bufferSizeBytes, Compression compression) {
        this.bufferSizeBytes = bufferSizeBytes;
        this.compression = compression;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        try {
            SizedInputStream sizedIs = this.createInputStream();
            this.size = sizedIs.getSize();
            this.inputByteCounterStream = new ThreadSafeCountingInputStream(sizedIs);
            InputStream cis = FileUtils.getCompressionInputStream(this.inputByteCounterStream, this.compression);
            this.is = this.bufferSizeBytes > 0 ? new BufferedInputStream(cis, this.bufferSizeBytes) : cis;
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        FileUtils.close((Closeable)this.is);
    }

    protected abstract SizedInputStream createInputStream() throws IOException, IOPipeException, InterruptedException;

    protected InputStream getInputStream() {
        return this.is;
    }

    protected Long getInputStreamSize() {
        return this.size;
    }

    @Override
    public float getProgress() {
        if (this.size == null) {
            try {
                return this.peek() == null ? 1.0f : 0.0f;
            }
            catch (PipeException e) {
                return 0.0f;
            }
        }
        if (this.size == 0L) {
            return 1.0f;
        }
        return (float)this.getBytesRead() / (float)this.size.longValue();
    }

    private long getBytesRead() {
        return this.inputByteCounterStream.getCount();
    }
}

