/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.IOException;
import java.util.Iterator;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class IteratorReaderPipe<T>
implements Pipe<T> {
    private final Iterator<T> iterator;
    private T next;
    private Integer totalSize;
    private int pos;

    public IteratorReaderPipe(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public IteratorReaderPipe(Iterator<T> iterator, Integer totalSize) {
        this(iterator);
        this.totalSize = totalSize;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        if (this.next == null) {
            return null;
        }
        T current = this.next;
        this.prepareNext();
        ++this.pos;
        return current;
    }

    @Override
    public T peek() {
        return this.next;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.prepareNext();
    }

    private void prepareNext() {
        this.next = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    @Override
    public float getProgress() {
        if (this.totalSize != null) {
            return (float)this.pos / (float)this.totalSize.intValue();
        }
        return this.next == null ? 1.0f : 0.0f;
    }
}

