/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.infra.concurrent.FailableSupplier;
import org.pipecraft.pipes.exceptions.JdbcPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;

public class JdbcQueryResultsPipe<T>
implements Pipe<T> {
    private final FailableSupplier<Connection, SQLException> connectionSupplier;
    private final String query;
    private final FailableFunction<ResultSet, T, SQLException> rowMapper;
    private Connection connection;
    private Statement statement;
    private ResultSet resultSet;
    private T next;
    private volatile boolean done;

    public JdbcQueryResultsPipe(FailableSupplier<Connection, SQLException> connectionSupplier, String query, FailableFunction<ResultSet, T, SQLException> rowMapper) {
        this.connectionSupplier = connectionSupplier;
        this.query = query;
        this.rowMapper = rowMapper;
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        T toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public T peek() throws PipeException {
        return this.next;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        try {
            this.connection = this.connectionSupplier.get();
            this.statement = this.connection.createStatement();
            this.resultSet = this.statement.executeQuery(this.query);
            this.prepareNext();
        }
        catch (SQLException e) {
            this.closeResources(e);
            throw new JdbcPipeException(e);
        }
    }

    @Override
    public float getProgress() {
        if (this.done) {
            return 1.0f;
        }
        return 0.0f;
    }

    private void prepareNext() throws PipeException {
        try {
            if (!this.done && this.resultSet.next()) {
                this.next = this.rowMapper.apply(this.resultSet);
            } else {
                this.next = null;
                this.done = true;
            }
        }
        catch (SQLException e) {
            this.closeResources(e);
            throw new JdbcPipeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        SQLException e = this.closeResources(null);
        if (e != null) {
            throw new IOException(e);
        }
    }

    private SQLException closeResources(SQLException source) {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                if (source != null) {
                    source.addSuppressed(e);
                }
                source = e;
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                if (source != null) {
                    source.addSuppressed(e);
                }
                source = e;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                if (source != null) {
                    source.addSuppressed(e);
                }
                source = e;
            }
        }
        return source;
    }
}

