/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.exceptions.QueuePipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.utils.QueueItem;

public class QueueReaderPipe<T>
implements Pipe<T> {
    private final BlockingQueue<QueueItem<T>> queue;
    private boolean complete;

    public QueueReaderPipe(BlockingQueue<QueueItem<T>> queue) {
        this.queue = queue;
    }

    @Deprecated
    public QueueReaderPipe(BlockingQueue<T> queue, T successMarker, T errorMarker) {
        this.queue = queue;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
    }

    @Override
    public float getProgress() {
        if (this.complete) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public T next() throws PipeException, InterruptedException {
        if (this.complete) {
            return null;
        }
        QueueItem<T> queueItem = this.queue.take();
        if (queueItem.isSuccessfulEndOfData()) {
            this.complete = true;
            return null;
        }
        Throwable e = queueItem.getThrowable();
        if (e != null) {
            this.complete = true;
            throw new QueuePipeException("Error signaled by queue producer", e);
        }
        return queueItem.getItem();
    }

    @Override
    public T peek() throws PipeException {
        try {
            QueueItem itemW;
            while ((itemW = (QueueItem)this.queue.peek()) == null) {
                Thread.sleep(10L);
            }
            if (itemW.isSuccessfulEndOfData()) {
                return null;
            }
            Throwable e = itemW.getThrowable();
            if (e != null) {
                throw new QueuePipeException("Error signaled by queue producer", e);
            }
            return itemW.getItem();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

