/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.storage.Bucket;
import org.pipecraft.infra.storage.PathUtils;
import org.pipecraft.infra.storage.Storage;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.sync.inter.CompoundPipe;
import org.pipecraft.pipes.sync.source.TxtFileReaderPipe;

public class StorageTxtFileFetcherReaderPipe
extends CompoundPipe<String> {
    private static final int DEFAULT_CHUNK_SIZE = 0;
    private static final FileReadOptions DEFAULT_FILE_READ_OPTIONS = new FileReadOptions();
    private final Storage<?, ?> storage;
    private final String bucketName;
    private final String path;
    private final Charset charset;
    private final int chunkSize;
    private final FileReadOptions readOptions;
    private final File tempFolder;
    private File tmpFile;

    public StorageTxtFileFetcherReaderPipe(Storage<?, ?> storage, String bucket, String path, Charset charset, int chunkSize, FileReadOptions options, File tempFolder) {
        this.storage = storage;
        this.bucketName = bucket;
        this.path = path;
        this.charset = charset;
        this.chunkSize = chunkSize;
        this.readOptions = options;
        this.tempFolder = tempFolder;
    }

    public StorageTxtFileFetcherReaderPipe(Storage<?, ?> storage, String bucket, String path, Charset charset, File tempFolder) {
        this(storage, bucket, path, charset, 0, DEFAULT_FILE_READ_OPTIONS, tempFolder);
    }

    public StorageTxtFileFetcherReaderPipe(Storage<?, ?> storage, String bucket, String path, File tempFolder) {
        this(storage, bucket, path, StandardCharsets.UTF_8, 0, DEFAULT_FILE_READ_OPTIONS, tempFolder);
    }

    public StorageTxtFileFetcherReaderPipe(Storage<?, ?> storage, String bucket, String path, FileReadOptions options, File tempFolder) {
        this(storage, bucket, path, StandardCharsets.UTF_8, 0, options, tempFolder);
    }

    @Override
    protected Pipe<String> createPipeline() throws PipeException, InterruptedException {
        try {
            Object bucket = this.storage.getBucket(this.bucketName);
            this.tmpFile = FileUtils.createTempFile("downloaded_" + PathUtils.getLastPathPart(this.path), ".tmp", this.tempFolder);
            ((Bucket)bucket).getSliced(this.path, this.tmpFile, this.chunkSize);
            return new TxtFileReaderPipe(this.tmpFile, this.charset, this.readOptions);
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.tmpFile.delete();
    }
}

