/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.concurrent.FailableInterruptibleSupplier;
import org.pipecraft.infra.io.Compression;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.source.InputStreamPipe;

public class TxtFileReaderPipe
extends InputStreamPipe<String> {
    private final FailableInterruptibleSupplier<SizedInputStream, IOException> isCreator;
    private final Charset charset;
    private final int bufferSize;
    private BufferedReader reader;
    private String next;

    public TxtFileReaderPipe(FailableInterruptibleSupplier<SizedInputStream, IOException> isCreator, Charset charset, int bufferSizeBytes, Compression compression) {
        super(0, compression);
        this.isCreator = isCreator;
        this.charset = charset;
        this.bufferSize = bufferSizeBytes;
    }

    public TxtFileReaderPipe(SizedInputStream is, Charset charset, int bufferSizeBytes, Compression compression) {
        this(() -> is, charset, bufferSizeBytes, compression);
    }

    public TxtFileReaderPipe(File f, Charset charset, FileReadOptions options) {
        this(() -> new SizedInputStream(new FileInputStream(f), f.length()), charset, options.getBufferSize(), options.getCompression());
    }

    public TxtFileReaderPipe(File f, Charset charset) {
        this(f, charset, new FileReadOptions().detectCompression(f.getName()));
    }

    public TxtFileReaderPipe(File f) {
        this(f, StandardCharsets.UTF_8, new FileReadOptions().detectCompression(f.getName()));
    }

    public TxtFileReaderPipe(File f, FileReadOptions options) {
        this(f, StandardCharsets.UTF_8, options);
    }

    @Override
    public String next() throws PipeException, InterruptedException {
        String toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public String peek() {
        return this.next;
    }

    @Override
    protected SizedInputStream createInputStream() throws IOException, InterruptedException {
        return this.isCreator.get();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        super.start();
        this.reader = TxtFileReaderPipe.toReader(this.getInputStream(), this.charset, this.bufferSize);
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        FileUtils.close((Closeable)this.reader);
    }

    private void prepareNext() throws IOPipeException {
        try {
            this.next = this.reader.readLine();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    private static BufferedReader toReader(InputStream is, Charset charset, int bufferSize) {
        return new BufferedReader(new InputStreamReader(is, charset), bufferSize);
    }
}

