/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.sync.source;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.io.FileReadOptions;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.SizedInputStream;
import org.pipecraft.pipes.exceptions.HttpPipeException;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.source.InputStreamPipe;

public class URLTxtReaderPipe
extends InputStreamPipe<String> {
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 2000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 1000;
    private final Charset charset;
    private final URL url;
    private final FileReadOptions readOptions;
    private final int connectionTimeoutMs;
    private final int readTimeoutMs;
    private BufferedReader reader;
    private String next;

    public URLTxtReaderPipe(URL url, Charset charset, FileReadOptions options, int connectTimeoutMs, int readTimeoutMs) {
        super(0, options.getCompression());
        this.url = url;
        this.charset = charset;
        this.readOptions = options;
        this.connectionTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
    }

    public URLTxtReaderPipe(URL url) {
        this(url, StandardCharsets.UTF_8, new FileReadOptions(), 2000, 1000);
    }

    @Override
    public String next() throws PipeException, InterruptedException {
        String toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    @Override
    public String peek() {
        return this.next;
    }

    @Override
    protected SizedInputStream createInputStream() throws IOException, IOPipeException, InterruptedException {
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            HttpRequest request;
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
            try {
                request = HttpRequest.newBuilder().uri(this.url.toURI()).build();
            }
            catch (URISyntaxException e) {
                throw new IOException("URL is not a valid URI: " + this.url, e);
            }
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            int statusCode = response.statusCode();
            if (statusCode != 200) {
                FileUtils.closeSilently(response.body());
                throw new HttpPipeException(statusCode);
            }
            Long length = response.headers().firstValue("content-length").map(Long::parseLong).orElse(null);
            return new SizedInputStream(response.body(), length);
        }
        URLConnection connection = this.url.openConnection();
        connection.setConnectTimeout(this.connectionTimeoutMs);
        connection.setReadTimeout(this.readTimeoutMs);
        return new SizedInputStream(connection.getInputStream(), connection.getContentLengthLong());
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        super.start();
        this.reader = URLTxtReaderPipe.toReader(this.getInputStream(), this.charset, this.readOptions.getBufferSize());
        this.prepareNext();
    }

    @Override
    public void close() throws IOException {
        FileUtils.close((Closeable)this.reader);
    }

    private void prepareNext() throws IOPipeException {
        try {
            this.next = this.reader.readLine();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }

    private static BufferedReader toReader(InputStream is, Charset charset, int bufferSize) {
        return new BufferedReader(new InputStreamReader(is, charset), bufferSize);
    }
}

