/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.pipecraft.pipes.async.AsyncPipe;
import org.pipecraft.pipes.async.AsyncPipeListener;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class AsyncCollectionWriterPipe<T>
extends TerminalPipe {
    private final AsyncPipe<T> input;
    private final Collection<T> outputCollection;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private volatile PipeException exception;

    public AsyncCollectionWriterPipe(AsyncPipe<T> input, final Collection<T> outputCollection) {
        this.input = input;
        this.outputCollection = outputCollection;
        input.setListener(new AsyncPipeListener<T>(){

            @Override
            public void next(T item) {
                outputCollection.add(item);
            }

            @Override
            public void done() {
                AsyncCollectionWriterPipe.this.terminationLatch.countDown();
            }

            @Override
            public void error(PipeException e) {
                AsyncCollectionWriterPipe.this.exception = e;
                AsyncCollectionWriterPipe.this.terminationLatch.countDown();
            }
        });
    }

    public AsyncCollectionWriterPipe(AsyncPipe<T> input) {
        this(input, Collections.synchronizedList(new ArrayList()));
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        this.terminationLatch.await();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public Collection<T> getItems() {
        return this.outputCollection;
    }
}

