/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.pipecraft.infra.concurrent.FailableFunction;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.exceptions.ValidationPipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class MapWriterPipe<T, K, V>
extends TerminalPipe {
    private final Pipe<T> input;
    private final Map<K, V> outputMap;
    private final FailableFunction<T, K, ValidationPipeException> keyExtractor;
    private final FailableFunction<T, V, ValidationPipeException> valueExtractor;

    public MapWriterPipe(Pipe<T> inputPipe, FailableFunction<T, K, ValidationPipeException> keyExtractor, FailableFunction<T, V, ValidationPipeException> valueExtractor) {
        this(inputPipe, keyExtractor, valueExtractor, new HashMap());
    }

    public MapWriterPipe(Pipe<T> inputPipe, FailableFunction<T, K, ValidationPipeException> keyExtractor, FailableFunction<T, V, ValidationPipeException> valueExtractor, Map<K, V> outputMap) {
        this.input = inputPipe;
        this.keyExtractor = keyExtractor;
        this.valueExtractor = valueExtractor;
        this.outputMap = outputMap;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        T item;
        this.input.start();
        while ((item = this.input.next()) != null) {
            K key = this.keyExtractor.apply(item);
            V value = this.valueExtractor.apply(item);
            this.outputMap.put(key, value);
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    public Map<K, V> getItems() {
        return this.outputMap;
    }
}

