/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;
import org.pipecraft.pipes.utils.QueueItem;

public class QueueWriterPipe<T>
extends TerminalPipe {
    private final BlockingQueue<QueueItem<T>> queue;
    private final Pipe<T> inputPipe;

    public QueueWriterPipe(Pipe<T> inputPipe, BlockingQueue<QueueItem<T>> queue) {
        this.inputPipe = inputPipe;
        this.queue = queue;
    }

    @Deprecated
    public QueueWriterPipe(Pipe<T> inputPipe, BlockingQueue<T> queue, T successMarker, T errorMarker) {
        this.inputPipe = inputPipe;
        this.queue = queue;
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        try {
            T item;
            this.inputPipe.start();
            while ((item = this.inputPipe.next()) != null) {
                this.queue.put(QueueItem.of(item));
            }
            this.queue.put(QueueItem.end());
        }
        catch (Throwable e) {
            while (!this.queue.offer(QueueItem.error(e))) {
                this.queue.clear();
            }
            throw e;
        }
    }

    @Override
    public float getProgress() {
        return this.inputPipe.getProgress();
    }

    @Override
    public void close() throws IOException {
        this.inputPipe.close();
    }
}

