/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.infra.storage.Bucket;
import org.pipecraft.infra.storage.Storage;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class StorageTxtFileWriterPipe
extends TerminalPipe {
    private final Pipe<String> input;
    private final Storage<?, ?> storage;
    private final String bucketName;
    private final String path;
    private final Charset charset;
    private final int chunkSize;
    private final FileWriteOptions options;

    public StorageTxtFileWriterPipe(Pipe<String> input, Storage<?, ?> storage, String bucket, String path, Charset charset, int chunkSize, FileWriteOptions options) {
        this.input = input;
        this.storage = storage;
        this.bucketName = bucket;
        this.path = path;
        this.charset = charset;
        this.chunkSize = chunkSize;
        this.options = options;
    }

    public StorageTxtFileWriterPipe(Pipe<String> input, Storage<?, ?> gs, String bucket, String path, Charset charset) {
        this(input, gs, bucket, path, charset, 0, new FileWriteOptions());
    }

    public StorageTxtFileWriterPipe(Pipe<String> input, Storage<?, ?> storage, String bucket, String path, FileWriteOptions options) {
        this(input, storage, bucket, path, StandardCharsets.UTF_8, 0, options);
    }

    public StorageTxtFileWriterPipe(Pipe<String> input, Storage<?, ?> storage, String bucket, String path) {
        this(input, storage, bucket, path, StandardCharsets.UTF_8, 0, new FileWriteOptions());
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        BufferedWriter bw = null;
        try {
            String item;
            Object bucket = this.storage.getBucket(this.bucketName);
            OutputStream os = ((Bucket)bucket).getOutputStream(this.path, this.chunkSize);
            bw = FileUtils.getWriter(os, this.charset, this.options);
            this.input.start();
            while ((item = this.input.next()) != null) {
                bw.write(item);
                bw.newLine();
            }
            bw.flush();
        }
        catch (IOException e) {
            try {
                throw new IOPipeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.closeSilently(bw);
                throw throwable;
            }
        }
        FileUtils.closeSilently(bw);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

