/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.io.FileWriteOptions;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class TxtFileWriterPipe
extends TerminalPipe {
    private final Pipe<String> input;
    private final FileWriteOptions writeOptions;
    private final Charset charset;
    private final File file;

    public TxtFileWriterPipe(Pipe<String> input, File f, Charset charset, FileWriteOptions options) {
        this.input = input;
        this.file = f;
        this.charset = charset;
        this.writeOptions = options;
    }

    public TxtFileWriterPipe(Pipe<String> input, File f, Charset charset) {
        this(input, f, charset, new FileWriteOptions());
    }

    public TxtFileWriterPipe(Pipe<String> input, File f) {
        this(input, f, StandardCharsets.UTF_8, new FileWriteOptions());
    }

    public TxtFileWriterPipe(Pipe<String> input, File f, FileWriteOptions options) {
        this(input, f, StandardCharsets.UTF_8, options);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        try (BufferedWriter bw = FileUtils.getWriter(this.file, this.charset, this.writeOptions);){
            String item;
            while ((item = this.input.next()) != null) {
                bw.write(item);
                bw.newLine();
            }
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

