/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.terminal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.pipecraft.pipes.exceptions.IOPipeException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.sync.Pipe;
import org.pipecraft.pipes.terminal.TerminalPipe;

public class WriterPipe
extends TerminalPipe {
    private final BufferedWriter bw;
    private final Pipe<String> input;

    public WriterPipe(Pipe<String> input, Writer w) {
        this.bw = new BufferedWriter(w);
        this.input = input;
    }

    public WriterPipe(Pipe<String> input, Writer w, int bufferSize) {
        this.bw = new BufferedWriter(w, bufferSize);
        this.input = input;
    }

    @Override
    public void close() throws IOException {
        this.bw.close();
        this.input.close();
    }

    @Override
    public void start() throws PipeException, InterruptedException {
        this.input.start();
        try {
            String item;
            while ((item = this.input.next()) != null) {
                this.bw.write(item);
                this.bw.newLine();
            }
            this.bw.flush();
        }
        catch (IOException e) {
            throw new IOPipeException(e);
        }
    }
}

