/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.pipecraft.pipes.BasePipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeUtils {
    private static final Logger logger = LoggerFactory.getLogger(PipeUtils.class);

    public static void close(Collection<? extends BasePipe> pipes) {
        for (BasePipe basePipe : pipes) {
            try {
                if (basePipe == null) continue;
                basePipe.close();
            }
            catch (IOException e) {
                logger.warn("Unable to close pipe of type " + basePipe.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    public static void close(BasePipe ... pipes) {
        PipeUtils.close(Arrays.asList(pipes));
    }

    public static float getMaxProgress(Collection<? extends BasePipe> pipes) {
        float max = 0.0f;
        for (BasePipe basePipe : pipes) {
            float progress = basePipe.getProgress();
            if (!(progress > max)) continue;
            max = progress;
        }
        return max;
    }

    public static float getMinProgress(Collection<? extends BasePipe> pipes) {
        float min = 1.0f;
        for (BasePipe basePipe : pipes) {
            float progress = basePipe.getProgress();
            if (!(progress < min)) continue;
            min = progress;
        }
        return min;
    }

    public static float getAverageProgress(Collection<? extends BasePipe> pipes) {
        double sum = 0.0;
        for (BasePipe basePipe : pipes) {
            sum += (double)basePipe.getProgress();
        }
        return (float)(sum / (double)pipes.size());
    }
}

