/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.utils;

import java.util.function.Consumer;

public class ProgressTransformer
implements Consumer<Integer> {
    private final int from;
    private final int to;
    private final int step;
    private final Consumer<Integer> listener;
    private int lastPct = -1;

    public ProgressTransformer(Consumer<Integer> listener, int from, int to, int step) {
        this.listener = listener;
        this.from = from;
        this.to = to;
        this.step = step;
    }

    public ProgressTransformer(Consumer<Integer> listener, int from, int to) {
        this(listener, from, to, 1);
    }

    public ProgressTransformer(Consumer<Integer> listener, int step) {
        this(listener, 0, 100, step);
    }

    @Override
    public void accept(Integer pct) {
        int adaptedPct = (int)((double)this.from + (double)pct.intValue() / 100.0 * (double)(this.to - this.from));
        if (adaptedPct == this.from && this.lastPct == -1 || adaptedPct == this.to && this.lastPct != 100 || adaptedPct - this.lastPct >= this.step) {
            this.listener.accept(adaptedPct);
            this.lastPct = adaptedPct;
        }
    }
}

