/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.utils;

public class QueueItem<T> {
    private static final QueueItem<?> END = new QueueItem();
    private final T item;
    private final Throwable throwable;

    private QueueItem(T item, Throwable throwable) {
        this.item = item;
        this.throwable = throwable;
    }

    private QueueItem(T item) {
        this(item, null);
    }

    private QueueItem(Throwable throwable) {
        this(null, throwable);
    }

    private QueueItem() {
        this(null, null);
    }

    public static <T> QueueItem<T> of(T item) {
        return new QueueItem<T>(item);
    }

    public static <T> QueueItem<T> error(Throwable e) {
        return new QueueItem<T>(e);
    }

    public static <T> QueueItem<T> end() {
        return END;
    }

    public T getItem() {
        return this.item;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isEndOfData() {
        return this.item == null;
    }

    public boolean isSuccessfulEndOfData() {
        return this == END;
    }
}

