/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.utils;

import java.util.Objects;

public class ShardSpecifier {
    public static final ShardSpecifier ALL = new ShardSpecifier(0, 1);
    private final int shardIndex;
    private final int shardCount;

    public ShardSpecifier(int shardIndex, int shardCount) {
        if (shardIndex >= shardCount) {
            throw new IllegalArgumentException("Shard index must be between 0 and shardCount-1, but got shardIndex=" + shardIndex + ", shardCount=" + shardCount);
        }
        if (shardIndex < 0) {
            throw new IllegalArgumentException("Shard index must be non-negative, but got shardIndex=" + shardIndex);
        }
        this.shardIndex = shardIndex;
        this.shardCount = shardCount;
    }

    public int getShardIndex() {
        return this.shardIndex;
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public String toString() {
        return this.shardIndex + "/" + this.shardCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSpecifier that = (ShardSpecifier)o;
        return this.shardIndex == that.shardIndex && this.shardCount == that.shardCount;
    }

    public int hashCode() {
        return Objects.hash(this.shardIndex, this.shardCount);
    }
}

