/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.bq;

import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.TableId;

public class QueryExecutionConfig {
    private final Long timeoutMillis;
    private final boolean disableCache;
    private final int maxRowsPerPage;
    private final Long maxResults;
    private final TableId destinationTableReference;
    private final Integer destinationTableExpirationHs;
    private final JobInfo.WriteDisposition writeDisposition;
    private final QueryJobConfiguration.Priority priority;

    private QueryExecutionConfig(Builder builder) {
        this.timeoutMillis = builder.getTimeoutMs();
        this.disableCache = builder.isCacheDisabled();
        this.maxRowsPerPage = builder.getMaxRowsPerPage();
        this.maxResults = builder.getMaxResults();
        this.destinationTableReference = builder.getDestinationTableReference();
        this.writeDisposition = builder.getWriteDisposition();
        this.priority = builder.getPriority();
        this.destinationTableExpirationHs = builder.getDestinationTableExpirationHs();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(QueryExecutionConfig config) {
        return new Builder(config);
    }

    public Builder toBuilder() {
        return QueryExecutionConfig.newBuilder(this);
    }

    public Long getTimeoutMs() {
        return this.timeoutMillis;
    }

    public boolean isCacheDisabled() {
        return this.disableCache;
    }

    public int getMaxRowsPerPage() {
        return this.maxRowsPerPage;
    }

    public Long getMaxResults() {
        return this.maxResults;
    }

    public TableId getDestinationTableReference() {
        return this.destinationTableReference;
    }

    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    public QueryJobConfiguration.Priority getPriority() {
        return this.priority;
    }

    public Integer getDestinationTableExpirationHs() {
        return this.destinationTableExpirationHs;
    }

    public static class Builder {
        private Long timeoutMillis;
        private boolean disableCache;
        private int maxRowsPerPage = 10000;
        private Long maxResults;
        private TableId destinationTableReference;
        private Integer destinationTableExpirationHs;
        private JobInfo.WriteDisposition writeDisposition = JobInfo.WriteDisposition.WRITE_EMPTY;
        private QueryJobConfiguration.Priority priority = QueryJobConfiguration.Priority.INTERACTIVE;

        private Builder() {
        }

        private Builder(QueryExecutionConfig config) {
            this.timeoutMillis = config.getTimeoutMs();
            this.disableCache = config.isCacheDisabled();
            this.maxRowsPerPage = config.getMaxRowsPerPage();
            this.maxResults = config.getMaxResults();
            this.destinationTableReference = config.getDestinationTableReference();
            this.writeDisposition = config.getWriteDisposition();
            this.priority = config.getPriority();
            this.destinationTableExpirationHs = config.getDestinationTableExpirationHs();
        }

        public Builder setTimeoutMs(Long timeoutMs) {
            this.timeoutMillis = timeoutMs;
            return this;
        }

        public Long getTimeoutMs() {
            return this.timeoutMillis;
        }

        public Builder setDisableCache(boolean disableCache) {
            this.disableCache = disableCache;
            return this;
        }

        public boolean isCacheDisabled() {
            return this.disableCache;
        }

        public Builder setMaxRowsPerPage(int maxRowsPerPage) {
            this.maxRowsPerPage = maxRowsPerPage;
            return this;
        }

        public int getMaxRowsPerPage() {
            return this.maxRowsPerPage;
        }

        public Builder setMaxResults(Long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Long getMaxResults() {
            return this.maxResults;
        }

        public Builder setTableDestinationReference(TableId tableConfig) {
            this.destinationTableReference = tableConfig;
            return this;
        }

        public TableId getDestinationTableReference() {
            return this.destinationTableReference;
        }

        public Builder setWriteDisposition(JobInfo.WriteDisposition action) {
            this.writeDisposition = action;
            return this;
        }

        public JobInfo.WriteDisposition getWriteDisposition() {
            return this.writeDisposition;
        }

        public Builder setPriority(QueryJobConfiguration.Priority priority) {
            this.priority = priority;
            return this;
        }

        public QueryJobConfiguration.Priority getPriority() {
            return this.priority;
        }

        public Integer getDestinationTableExpirationHs() {
            return this.destinationTableExpirationHs;
        }

        public Builder setDestinationTableExpirationHs(Integer destinationTableExpirationHs) {
            this.destinationTableExpirationHs = destinationTableExpirationHs;
            return this;
        }

        public QueryExecutionConfig build() {
            return new QueryExecutionConfig(this);
        }
    }
}

