/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.bq;

import java.util.Iterator;
import java.util.function.Consumer;
import org.pipecraft.infra.bq.BQQuery;
import org.pipecraft.infra.bq.exceptions.BQException;
import org.pipecraft.infra.bq.exceptions.QueryResultBrokenException;
import org.pipecraft.infra.bq.exceptions.TransientBQException;

public class BQResultsIterator<R, F>
implements Iterator<R> {
    private final Iterator<R> iterator;
    private final long recordCount;
    private final BQQuery<R, F> query;

    BQResultsIterator(BQQuery<R, F> query, Iterator<R> iterator, long recordCount) {
        this.query = query;
        this.iterator = iterator;
        this.recordCount = recordCount;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.iterator.hasNext();
        }
        catch (Exception e) {
            throw new QueryResultBrokenException(e);
        }
    }

    @Override
    public R next() {
        try {
            return this.iterator.next();
        }
        catch (Exception e) {
            throw new QueryResultBrokenException(e);
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super R> action) {
        try {
            this.iterator.forEachRemaining(action);
        }
        catch (Exception e) {
            throw new QueryResultBrokenException(e);
        }
    }

    public long totalRecordCount() {
        return this.recordCount;
    }

    public F aggregate() throws BQException {
        try {
            return this.query.aggregate(this);
        }
        catch (QueryResultBrokenException e) {
            throw new TransientBQException("Failed iterating over query results", e);
        }
    }
}

