/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.bq;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.pipecraft.infra.bq.BQDMLQuery;

public class CreateTableDMLQuery
implements BQDMLQuery {
    private static final ZoneId UTC = ZoneId.of("UTC");
    private static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final String dataSetId;
    private final String tableName;
    private final String schema;
    private final Duration expirationDuration;

    public CreateTableDMLQuery(String dataSetId, String tableName, String schema, Duration expiration) {
        this.dataSetId = dataSetId;
        this.tableName = tableName;
        this.schema = schema;
        this.expirationDuration = expiration;
    }

    @Override
    public String getSQL() {
        String expirationExpression = this.expirationDuration == null ? "" : " OPTIONS (expiration_timestamp=TIMESTAMP \"" + ZonedDateTime.now(UTC).plus(this.expirationDuration).format(DATE_TIME_FORMATTER) + " UTC\")";
        return "CREATE OR REPLACE TABLE " + this.dataSetId + "." + this.tableName + " " + this.schema + expirationExpression;
    }
}

