/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.bq;

import com.google.cloud.bigquery.TableId;
import java.util.Collections;
import java.util.Set;

public class TableExportConfig {
    private final TableId sourceTableReference;
    private final Set<String> destinationURIs;
    private final ExportFormat exportFormat;
    private final Compression compression;
    private final char csvFieldDelimiter;
    private final boolean printHeader;
    private final Long timeoutMillis;

    public static Builder newBuilder(TableId sourceTableReference, Set<String> destinationURIs) {
        return new Builder(sourceTableReference, destinationURIs);
    }

    public static Builder newBuilder(TableId sourceTableReference, String destinationURI) {
        return new Builder(sourceTableReference, destinationURI);
    }

    private TableExportConfig(Builder builder) {
        this.exportFormat = builder.getExportFormat();
        this.compression = builder.getCompression();
        this.csvFieldDelimiter = builder.getCSVFieldDelimiter();
        this.printHeader = builder.isPrintHeader();
        this.sourceTableReference = builder.getSourceTableReference();
        this.destinationURIs = builder.getDestinationURIs();
        this.timeoutMillis = builder.getTimeoutMs();
    }

    public ExportFormat getExportFormat() {
        return this.exportFormat;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public char getCSVFieldDelimiter() {
        return this.csvFieldDelimiter;
    }

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public TableId getSourceTableReference() {
        return this.sourceTableReference;
    }

    public Set<String> getDestinationURIs() {
        return this.destinationURIs;
    }

    public Long getTimeoutMs() {
        return this.timeoutMillis;
    }

    public String toString() {
        return "TableExportConfig [sourceTableReference=" + this.sourceTableReference + ", destinationURIs=" + this.destinationURIs + ", exportFormat=" + this.exportFormat + ", compression=" + this.compression + ", csvFieldDelimiter=" + this.csvFieldDelimiter + ", printHeader=" + this.printHeader + ", timeoutMillis=" + this.timeoutMillis + "]";
    }

    public static class Builder {
        private final TableId sourceTableReference;
        private final Set<String> destinationURIs;
        private ExportFormat exportFormat = ExportFormat.CSV;
        private Compression compression = Compression.NONE;
        private char csvFieldDelimiter = (char)44;
        private boolean printHeader = true;
        private Long timeoutMillis;

        public Builder(TableId sourceTableReference, Set<String> destinationURIs) {
            this.sourceTableReference = sourceTableReference;
            this.destinationURIs = destinationURIs;
        }

        public Builder(TableId sourceTableReference, String destinationURI) {
            this(sourceTableReference, Collections.singleton(destinationURI));
        }

        public Builder setExportFormat(ExportFormat exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        public ExportFormat getExportFormat() {
            return this.exportFormat;
        }

        public Builder setCompression(Compression compression) {
            this.compression = compression;
            return this;
        }

        public Compression getCompression() {
            return this.compression;
        }

        public Builder setFieldDelimiter(char csvFieldDelimiter) {
            this.csvFieldDelimiter = csvFieldDelimiter;
            return this;
        }

        public char getCSVFieldDelimiter() {
            return this.csvFieldDelimiter;
        }

        public Builder setPrintHeader(boolean printHeader) {
            this.printHeader = printHeader;
            return this;
        }

        public boolean isPrintHeader() {
            return this.printHeader;
        }

        public TableId getSourceTableReference() {
            return this.sourceTableReference;
        }

        public Set<String> getDestinationURIs() {
            return this.destinationURIs;
        }

        public Builder setTimeoutMs(Long timeoutMs) {
            this.timeoutMillis = timeoutMs;
            return this;
        }

        public Long getTimeoutMs() {
            return this.timeoutMillis;
        }

        public TableExportConfig build() {
            return new TableExportConfig(this);
        }
    }

    public static enum Compression {
        NONE,
        GZIP;

    }

    public static enum ExportFormat {
        CSV,
        NEWLINE_DELIMITED_JSON,
        AVRO;

    }
}

