/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.bq;

import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Set;

public class TableLoadConfig {
    private final Set<String> sourceURIs;
    private final TableId destinationTableReference;
    private final LocalDate destinationTablePartition;
    private final LoadFormat loadFormat;
    private final String csvFieldDelimiter;
    private final boolean csvHasHeader;
    private final Schema tableSchema;
    private final Integer destinationTableExpirationHs;
    private final JobInfo.WriteDisposition writeDisposition;
    private final JobInfo.CreateDisposition createDisposition;
    private final boolean allowJaggedRows;
    private final Long timeoutMillis;
    private final Set<String> clusteringFields;

    private TableLoadConfig(Builder builder) {
        this.sourceURIs = builder.getSourceURIs();
        this.destinationTableReference = builder.getDestinationTableReference();
        this.destinationTablePartition = builder.getDestinationTablePartition();
        this.loadFormat = builder.getLoadFormat();
        this.csvFieldDelimiter = builder.getCSVFieldDelimiter();
        this.csvHasHeader = builder.getCSVHasHeader();
        this.tableSchema = builder.getTableSchema();
        this.destinationTableExpirationHs = builder.getDestinationTableExpirationHs();
        this.writeDisposition = builder.getWriteDisposition();
        this.createDisposition = builder.getCreateDisposition();
        this.allowJaggedRows = builder.getAllowJaggedRows();
        this.timeoutMillis = builder.getTimeoutMs();
        this.clusteringFields = builder.getClusteringFields();
    }

    public static Builder newBuilder(Set<String> sourceURIs, TableId destinationTableReference) {
        return new Builder(sourceURIs, destinationTableReference);
    }

    public static Builder newBuilder(String sourceURI, TableId destinationTableReference) {
        return new Builder(sourceURI, destinationTableReference);
    }

    public Set<String> getSourceURIs() {
        return this.sourceURIs;
    }

    public boolean isRemoteLoad() {
        return this.sourceURIs.isEmpty() || this.sourceURIs.iterator().next().startsWith("gs://");
    }

    public TableId getDestinationTableReference() {
        return this.destinationTableReference;
    }

    public LocalDate getDestinationTablePartition() {
        return this.destinationTablePartition;
    }

    public LoadFormat getLoadFormat() {
        return this.loadFormat;
    }

    public String getCsvFieldDelimiter() {
        return this.csvFieldDelimiter;
    }

    public boolean getCSVHasHeader() {
        return this.csvHasHeader;
    }

    public Schema getTableSchema() {
        return this.tableSchema;
    }

    public Integer getDestinationTableExpirationHs() {
        return this.destinationTableExpirationHs;
    }

    public JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    public boolean getAllowJaggedRows() {
        return this.allowJaggedRows;
    }

    public Set<String> getClusteringFields() {
        return this.clusteringFields;
    }

    public Long getTimeoutMs() {
        return this.timeoutMillis;
    }

    public String toString() {
        return "TableLoadConfig [sourceURIs=" + this.sourceURIs + ", destinationTableReference=" + this.destinationTableReference + ", destinationTablePartition=" + this.destinationTablePartition + ", loadFormat=" + this.loadFormat + ", csvFieldDelimiter=" + this.csvFieldDelimiter + ", csvHasHeader=" + this.csvHasHeader + ", tableSchema=" + this.tableSchema + ", destinationTableExpirationHs=" + this.destinationTableExpirationHs + ", writeDisposition=" + this.writeDisposition + ", createDisposition=" + this.createDisposition + ", allowJaggedRows=" + this.allowJaggedRows + ", timeoutMillis=" + this.timeoutMillis + ", clusteringFields=" + this.clusteringFields + "]";
    }

    public static class Builder {
        private final Set<String> sourceURIs;
        private final TableId destinationTableReference;
        private LocalDate destinationTablePartition;
        private LoadFormat loadFormat = LoadFormat.CSV;
        private String csvFieldDelimiter = ",";
        private boolean csvHasHeader = true;
        private Schema tableSchema;
        private Integer destinationTableExpirationHs;
        private JobInfo.WriteDisposition writeDisposition = JobInfo.WriteDisposition.WRITE_APPEND;
        private JobInfo.CreateDisposition createDisposition = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
        private boolean allowJaggedRows;
        private Long timeoutMillis;
        private Set<String> clusteringFields;

        private Builder(Set<String> sourceURIs, TableId destinationTableReference) {
            this.sourceURIs = sourceURIs;
            this.destinationTableReference = destinationTableReference;
        }

        private Builder(String sourceURI, TableId destinationTableReference) {
            this(Collections.singleton(sourceURI), destinationTableReference);
        }

        public Set<String> getSourceURIs() {
            return this.sourceURIs;
        }

        public TableId getDestinationTableReference() {
            return this.destinationTableReference;
        }

        public Builder setDestinationTablePartition(LocalDate partition) {
            this.destinationTablePartition = partition;
            return this;
        }

        public LocalDate getDestinationTablePartition() {
            return this.destinationTablePartition;
        }

        public Builder setLoadFormat(LoadFormat loadFormat) {
            this.loadFormat = loadFormat;
            return this;
        }

        public LoadFormat getLoadFormat() {
            return this.loadFormat;
        }

        public Builder setCSVFieldDelimiter(String csvFieldDelimiter) {
            this.csvFieldDelimiter = csvFieldDelimiter;
            return this;
        }

        public String getCSVFieldDelimiter() {
            return this.csvFieldDelimiter;
        }

        public Builder setCSVHasHeader(boolean csvHasHeader) {
            this.csvHasHeader = csvHasHeader;
            return this;
        }

        public boolean getCSVHasHeader() {
            return this.csvHasHeader;
        }

        public Builder setTableSchema(Schema tableSchema) {
            this.tableSchema = tableSchema;
            return this;
        }

        public Schema getTableSchema() {
            return this.tableSchema;
        }

        public Builder setDestinationTableExpirationHs(Integer destinationTableExpirationHs) {
            this.destinationTableExpirationHs = destinationTableExpirationHs;
            return this;
        }

        public Integer getDestinationTableExpirationHs() {
            return this.destinationTableExpirationHs;
        }

        public Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        public JobInfo.CreateDisposition getCreateDisposition() {
            return this.createDisposition;
        }

        public Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        public JobInfo.WriteDisposition getWriteDisposition() {
            return this.writeDisposition;
        }

        public Builder setAllowJaggedRows(boolean allowJaggedRows) {
            this.allowJaggedRows = allowJaggedRows;
            return this;
        }

        public boolean getAllowJaggedRows() {
            return this.allowJaggedRows;
        }

        public Builder setClusteringFields(Set<String> clusteringFields) {
            this.clusteringFields = clusteringFields;
            return this;
        }

        public Set<String> getClusteringFields() {
            return this.clusteringFields;
        }

        public Builder setTimeoutMs(Long timeoutMs) {
            this.timeoutMillis = timeoutMs;
            return this;
        }

        public Long getTimeoutMs() {
            return this.timeoutMillis;
        }

        public TableLoadConfig build() {
            return new TableLoadConfig(this);
        }
    }

    public static enum LoadFormat {
        CSV,
        NEWLINE_DELIMITED_JSON,
        AVRO;

    }
}

