/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.bq.exceptions;

import com.google.cloud.bigquery.QueryParameterValue;
import java.util.Map;
import org.pipecraft.infra.bq.BQQuery;

public abstract class BQException
extends Exception {
    public BQException(String msg, Throwable cause) {
        this(msg, cause, null);
    }

    public BQException(String msg) {
        this(msg, (BQQuery)null);
    }

    public BQException(Throwable cause, BQQuery<?, ?> query) {
        super(BQException.getQueryExpression(query), cause);
    }

    public BQException(String msg, BQQuery<?, ?> query) {
        super(msg + "\n" + BQException.getQueryExpression(query));
    }

    public BQException(String msg, Throwable cause, BQQuery<?, ?> query) {
        super(msg + "\n" + BQException.getQueryExpression(query), cause);
    }

    private static String getQueryExpression(BQQuery<?, ?> query) {
        if (query == null) {
            return "Query: N/A";
        }
        StringBuilder builder = new StringBuilder("Query: ").append(query.getSQL());
        Map<String, QueryParameterValue> queryParameters = query.getQueryParameters();
        if (queryParameters != null) {
            builder.append("\nParameters: ");
            for (Map.Entry<String, QueryParameterValue> paramPair : queryParameters.entrySet()) {
                QueryParameterValue paramValue = paramPair.getValue();
                String value = paramValue.getValue() != null ? paramValue.getValue() : String.valueOf(paramValue.getArrayValues());
                builder.append(paramPair.getKey()).append(": ").append(value).append("\n");
            }
        }
        return builder.toString();
    }
}

