/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.pipes.source.google_bq;

import java.io.IOException;
import org.pipecraft.infra.bq.BQQuery;
import org.pipecraft.infra.bq.BQResultsIterator;
import org.pipecraft.infra.bq.BigQueryConnector;
import org.pipecraft.infra.bq.QueryExecutionConfig;
import org.pipecraft.infra.bq.exceptions.BQException;
import org.pipecraft.infra.bq.exceptions.QueryResultBrokenException;
import org.pipecraft.pipes.exceptions.PipeException;
import org.pipecraft.pipes.exceptions.google_bq.BQPipeException;
import org.pipecraft.pipes.sync.Pipe;

public class BQQueryResultsPipe<T>
implements Pipe<T> {
    private final BigQueryConnector bq;
    private final BQQuery<T, ?> query;
    private final QueryExecutionConfig queryConfig;
    private BQResultsIterator<T, ?> it;
    private T next;
    private volatile long totalCount;
    private volatile long iterCount;

    public BQQueryResultsPipe(BigQueryConnector bq, BQQuery<T, ?> query, QueryExecutionConfig queryConfig) {
        this.bq = bq;
        this.query = query;
        this.queryConfig = queryConfig;
    }

    public void close() throws IOException {
    }

    public T next() throws PipeException, InterruptedException {
        T res = this.next;
        this.prepareNext();
        ++this.iterCount;
        return res;
    }

    public T peek() {
        return this.next;
    }

    public void start() throws PipeException, InterruptedException {
        try {
            this.it = this.queryConfig == null ? this.bq.execute(this.query) : this.bq.execute(this.query, this.queryConfig);
            this.totalCount = this.it.totalRecordCount();
            this.prepareNext();
        }
        catch (BQException e) {
            throw new BQPipeException(e);
        }
    }

    public void prepareNext() throws BQPipeException {
        try {
            this.next = this.it.hasNext() ? this.it.next() : null;
        }
        catch (QueryResultBrokenException e) {
            throw new BQPipeException(e);
        }
    }

    public float getProgress() {
        if (this.totalCount == 0L) {
            return 1.0f;
        }
        return (float)this.iterCount / (float)this.totalCount;
    }
}

