/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.storage.google_cs;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import java.io.Closeable;
import java.io.IOException;
import org.pipecraft.infra.io.FileUtils;
import org.pipecraft.infra.storage.google_cs.SlicedTransferFileHandler;

public class SliceTransferJobDetails
implements Closeable {
    private final SlicedTransferFileHandler targetFileHandler;
    private final long pos;
    private final long length;
    private final Blob readBlob;
    private final int chunkSize;
    private ReadChannel readChannel;

    public SliceTransferJobDetails(Blob readBlob, int chunkSize, SlicedTransferFileHandler targetFileHandler, long start, long length) {
        this.readBlob = readBlob;
        this.chunkSize = chunkSize;
        this.targetFileHandler = targetFileHandler;
        this.pos = start;
        this.length = length;
    }

    public ReadChannel getReadChannel() {
        if (this.readChannel == null) {
            this.readChannel = this.readBlob.reader(new Blob.BlobSourceOption[0]);
            this.readChannel.setChunkSize(this.chunkSize);
        }
        return this.readChannel;
    }

    public SlicedTransferFileHandler getTargetFileHandler() {
        return this.targetFileHandler;
    }

    public long getPosition() {
        return this.pos;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        FileUtils.close((Closeable[])new Closeable[]{this.readChannel, this.targetFileHandler.getWriter()});
    }
}

