/*
 * Decompiled with CFR 0.152.
 */
package org.pipecraft.infra.storage.google_cs;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicInteger;

public class SlicedTransferFileHandler {
    private final File file;
    private final int fileSliceCount;
    private final AtomicInteger completedSliceCounter = new AtomicInteger();
    private final Object channelCreationLock = new Object();
    private volatile FileChannel fileChannel;

    public SlicedTransferFileHandler(File file, int fileSliceCount) {
        this.file = file;
        this.fileSliceCount = fileSliceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getWriter() throws IOException {
        FileChannel channel = this.fileChannel;
        if (channel == null) {
            Object object = this.channelCreationLock;
            synchronized (object) {
                if (this.fileChannel == null) {
                    this.fileChannel = FileChannel.open(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                }
                channel = this.fileChannel;
            }
        }
        return channel;
    }

    public void doneSliceProcessing() throws IOException {
        if (this.completedSliceCounter.incrementAndGet() == this.fileSliceCount) {
            this.fileChannel.close();
        }
    }
}

