/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.messaging.queues;

import java.util.List;
import org.pipservices.commons.config.ConfigParams;
import org.pipservices.commons.config.IConfigurable;
import org.pipservices.commons.config.NameResolver;
import org.pipservices.commons.errors.ApplicationException;
import org.pipservices.commons.refer.IReferenceable;
import org.pipservices.commons.refer.IReferences;
import org.pipservices.commons.refer.ReferenceException;
import org.pipservices.commons.run.IClosable;
import org.pipservices.commons.run.IOpenable;
import org.pipservices.components.auth.CredentialParams;
import org.pipservices.components.auth.CredentialResolver;
import org.pipservices.components.connect.ConnectionParams;
import org.pipservices.components.connect.ConnectionResolver;
import org.pipservices.components.count.CompositeCounters;
import org.pipservices.components.log.CompositeLogger;
import org.pipservices.messaging.queues.IMessageQueue;
import org.pipservices.messaging.queues.IMessageReceiver;
import org.pipservices.messaging.queues.MessageEnvelop;
import org.pipservices.messaging.queues.MessagingCapabilities;

public abstract class MessageQueue
implements IMessageQueue,
IReferenceable,
IConfigurable,
IOpenable,
IClosable {
    protected String _name;
    protected String _kind;
    protected MessagingCapabilities _capabilities = new MessagingCapabilities(true, true, true, true, true, true, true, false, true);
    protected Object _lock = new Object();
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected ConnectionResolver _connectionResolver = new ConnectionResolver();
    protected CredentialResolver _credentialResolver = new CredentialResolver();

    public MessageQueue() {
    }

    public MessageQueue(String name) {
        this._name = name;
    }

    public MessageQueue(String name, ConfigParams config) {
        this._name = name;
        if (config != null) {
            this.configure(config);
        }
    }

    public void configure(ConfigParams config) {
        this._name = NameResolver.resolve((ConfigParams)config, (String)this._name);
        this._connectionResolver.configure(config, true);
        this._credentialResolver.configure(config, true);
    }

    public void setReferences(IReferences references) throws ReferenceException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._connectionResolver.setReferences(references);
        this._credentialResolver.setReferences(references);
    }

    @Override
    public String getName() {
        return this._name != null ? this._name : "undefined";
    }

    @Override
    public MessagingCapabilities getCapabilities() {
        return this._capabilities;
    }

    @Override
    public abstract Long getMessageCount();

    public abstract boolean isOpen();

    public void open(String correlationId) throws ApplicationException {
        ConnectionParams connection = this._connectionResolver.resolve(correlationId);
        CredentialParams credential = this._credentialResolver.lookup(correlationId);
        this.open(correlationId, connection, credential);
    }

    public abstract void open(String var1, ConnectionParams var2, CredentialParams var3) throws ApplicationException;

    public abstract void close(String var1) throws ApplicationException;

    public abstract void clear(String var1) throws ApplicationException;

    @Override
    public abstract void send(String var1, MessageEnvelop var2) throws ApplicationException;

    @Override
    public void sendAsObject(String correlationId, String messageType, Object message) throws ApplicationException {
        MessageEnvelop envelop = new MessageEnvelop(correlationId, messageType, message);
        this.send(correlationId, envelop);
    }

    @Override
    public abstract MessageEnvelop peek(String var1) throws ApplicationException;

    @Override
    public abstract List<MessageEnvelop> peekBatch(String var1, int var2) throws ApplicationException;

    @Override
    public abstract MessageEnvelop receive(String var1, long var2) throws ApplicationException;

    @Override
    public abstract void renewLock(MessageEnvelop var1, long var2) throws ApplicationException;

    @Override
    public abstract void abandon(MessageEnvelop var1) throws ApplicationException;

    @Override
    public abstract void complete(MessageEnvelop var1) throws ApplicationException;

    @Override
    public abstract void moveToDeadLetter(MessageEnvelop var1) throws ApplicationException;

    @Override
    public abstract void listen(String var1, IMessageReceiver var2) throws ApplicationException;

    @Override
    public void beginListen(final String correlationId, final IMessageReceiver receiver) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageQueue.this.listen(correlationId, receiver);
                }
                catch (Exception ex) {
                    MessageQueue.this._logger.error(correlationId, ex, "Failed to listen messages", new Object[0]);
                }
            }
        }).start();
    }

    @Override
    public abstract void endListen(String var1) throws ApplicationException;

    public String toString() {
        return "[" + this.getName() + "]";
    }
}

