/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.clients;

import org.pipservices.commons.config.ConfigParams;
import org.pipservices.commons.config.IConfigurable;
import org.pipservices.commons.errors.ConfigException;
import org.pipservices.commons.errors.ConnectionException;
import org.pipservices.commons.refer.DependencyResolver;
import org.pipservices.commons.refer.IReferenceable;
import org.pipservices.commons.refer.IReferences;
import org.pipservices.commons.refer.ReferenceException;
import org.pipservices.commons.run.IOpenable;
import org.pipservices.components.count.CompositeCounters;
import org.pipservices.components.count.Timing;
import org.pipservices.components.log.CompositeLogger;

public abstract class DirectClient<T>
implements IConfigurable,
IOpenable,
IReferenceable {
    protected T _controller;
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected DependencyResolver _dependencyResolver = new DependencyResolver();
    protected boolean _opened = false;

    public DirectClient() {
        this._dependencyResolver.put("controller", (Object)"none");
    }

    public void configure(ConfigParams config) throws ConfigException {
        this._dependencyResolver.configure(config);
    }

    public void setReferences(IReferences references) throws ReferenceException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._dependencyResolver.setReferences(references);
        this._controller = this._dependencyResolver.getOneRequired("controller");
    }

    protected Timing instrument(String correlationId, String methodName) {
        String typeName = this.getClass().getName();
        this._logger.trace(correlationId, "Calling %s method of %s", new Object[]{methodName, typeName});
        return this._counters.beginTiming(typeName + "." + methodName + ".call_time");
    }

    public boolean isOpen() {
        return this._opened;
    }

    public void open(String correlationId) throws ConnectionException {
        if (this.isOpen()) {
            return;
        }
        if (this._controller == null) {
            throw new ConnectionException(correlationId, "NO_CONTROLLER", "Controller reference is missing");
        }
        this._logger.info(correlationId, "Opened Direct client {0}", new Object[]{this.getClass().getName()});
        this._opened = true;
    }

    public void close(String correlationId) {
        if (this.isOpen()) {
            this._logger.debug(correlationId, "Closed Direct client {0}", new Object[]{this.getClass().getName()});
        }
        this._opened = false;
    }
}

