/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.clients;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.pipservices.commons.config.ConfigParams;
import org.pipservices.commons.config.IConfigurable;
import org.pipservices.commons.data.FilterParams;
import org.pipservices.commons.data.PagingParams;
import org.pipservices.commons.errors.ApplicationException;
import org.pipservices.commons.errors.ApplicationExceptionFactory;
import org.pipservices.commons.errors.ConfigException;
import org.pipservices.commons.errors.ErrorDescription;
import org.pipservices.commons.errors.InvalidStateException;
import org.pipservices.commons.errors.InvocationException;
import org.pipservices.commons.errors.UnknownException;
import org.pipservices.commons.refer.IReferenceable;
import org.pipservices.commons.refer.IReferences;
import org.pipservices.commons.refer.ReferenceException;
import org.pipservices.commons.run.IOpenable;
import org.pipservices.components.connect.ConnectionParams;
import org.pipservices.components.count.CompositeCounters;
import org.pipservices.components.count.Timing;
import org.pipservices.components.log.CompositeLogger;
import org.pipservices.rpc.connect.HttpConnectionResolver;

public class RestClient
implements IOpenable,
IConfigurable,
IReferenceable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples((Object[])new Object[]{"connection.protocol", "http", "connection.request_max_size", 0x100000, "connection.connect_timeout", 60000, "options.retries", 1, "connection.debug", true});
    protected HttpConnectionResolver _connectionResolver = new HttpConnectionResolver();
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected ConfigParams _options = new ConfigParams();
    protected String _baseRoute;
    protected int _retries = 1;
    protected String _url;
    protected Client _client;

    protected RestClient() {
        this(null);
    }

    protected RestClient(String baseRoute) {
        this._baseRoute = baseRoute;
    }

    public void configure(ConfigParams config) throws ConfigException {
        config = config.setDefaults(_defaultConfig);
        this._connectionResolver.configure(config);
        this._options = this._options.override(config.getSection("options"));
        this._retries = config.getAsIntegerWithDefault("options.retries", this._retries);
        this._baseRoute = config.getAsStringWithDefault("base_route", this._baseRoute);
    }

    public void setReferences(IReferences references) throws ReferenceException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._connectionResolver.setReferences(references);
    }

    protected Timing instrument(String correlationId, String name) {
        this._logger.trace(correlationId, "Calling %s method", new Object[]{name});
        return this._counters.beginTiming(name + ".call_time");
    }

    public boolean isOpen() {
        return this._client != null;
    }

    public void open(String correlationId) throws ApplicationException {
        if (this._client != null) {
            return;
        }
        ConnectionParams connection = this._connectionResolver.resolve(correlationId);
        String protocol = connection.getProtocol("http");
        String host = connection.getHost();
        int port = connection.getPort();
        this._url = protocol + "://" + host + ":" + port;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register((Object)new JacksonFeature());
        this._client = ClientBuilder.newClient((Configuration)clientConfig);
        this._logger.debug(correlationId, "Connected via REST to %s", new Object[]{this._url});
    }

    public void close(String correlationId) throws ApplicationException {
        if (this._client == null) {
            return;
        }
        this._client.close();
        this._client = null;
        this._url = null;
        this._logger.debug(correlationId, "Disconnected from %s", new Object[]{this._url});
    }

    private URI createRequestUri(String route) {
        StringBuilder builder = new StringBuilder(this._url);
        if (this._baseRoute != null && this._baseRoute.trim().length() > 0) {
            if (this._baseRoute.charAt(0) != '/') {
                builder.append('/');
            }
            builder.append(this._baseRoute);
        }
        if (route.charAt(0) != '/') {
            builder.append('/');
        }
        builder.append(route);
        String uri = builder.toString();
        URI result = UriBuilder.fromUri((String)uri).build(new Object[0]);
        return result;
    }

    private String addQueryParameter(String query, String name, String value) {
        try {
            name = URLEncoder.encode(name, "UTF-8");
            value = value != null ? URLEncoder.encode(value, "UTF-8") : "";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int pos = query.indexOf(63);
        String path = pos >= 0 ? query.substring(0, pos) : query;
        String parameters = pos >= 0 ? query.substring(pos) : "";
        return path + "?" + (parameters.equals("") ? "" : "&") + name + "=" + value;
    }

    protected String addCorrelationId(String route, String correlationId) {
        return this.addQueryParameter(route, "correlation_id", correlationId);
    }

    protected String addFilterParams(String route, FilterParams filter) {
        for (String key : filter.keySet()) {
            route = this.addQueryParameter(route, key, filter.get(key));
        }
        return route;
    }

    protected String addPagingParams(String route, PagingParams paging) {
        if (paging.getSkip() != null) {
            route = this.addQueryParameter(route, "skip", paging.getSkip().toString());
        }
        if (paging.getTake() != null) {
            route = this.addQueryParameter(route, "take", paging.getTake().toString());
        }
        if (paging.hasTotal()) {
            route = this.addQueryParameter(route, "total", paging.getTake().toString());
        }
        return route;
    }

    protected Response executeRequest(String correlationId, String method, URI uri, String mediaType, Entity<?> body) throws ApplicationException {
        if (this._client == null) {
            throw new InvalidStateException(correlationId, "NOT_OPENED", "Client is not opened");
        }
        Response response = null;
        int retries = Math.min(1, Math.max(5, this._retries));
        while (retries > 0) {
            try {
                if (method.equals("GET")) {
                    response = this._client.target(uri).request(new String[]{mediaType}).get();
                } else if (method.equals("POST")) {
                    response = this._client.target(uri).request(new String[]{mediaType}).post(body);
                } else if (method.equals("PUT")) {
                    response = this._client.target(uri).request(new String[]{mediaType}).put(body);
                } else if (method.equals("DELETE")) {
                    response = this._client.target(uri).request(new String[]{mediaType}).delete();
                } else {
                    throw new UnsupportedOperationException("Invalid request type");
                }
                retries = 0;
            }
            catch (Exception ex) {
                if (--retries < 0) {
                    throw ex;
                }
                this._logger.trace(correlationId, "Connection failed to uri " + uri + ". Retrying...", new Object[0]);
            }
        }
        if (response == null) {
            throw new UnknownException(correlationId, "NO_RESPONSE", "Unable to get a result from " + method + " " + uri);
        }
        if (response.getStatus() >= 400) {
            ErrorDescription errorObject = null;
            try {
                errorObject = (ErrorDescription)response.readEntity(ErrorDescription.class);
            }
            catch (Exception ex) {
                String responseContent = (String)response.readEntity(String.class);
                throw new UnknownException(correlationId, "UNKNOWN_ERROR", responseContent);
            }
            if (errorObject != null) {
                throw new ApplicationExceptionFactory().create(errorObject);
            }
        }
        return response;
    }

    private Response executeJsonRequest(String correlationId, String method, String route, Object requestEntity) throws ApplicationException {
        route = this.addCorrelationId(route, correlationId);
        URI uri = this.createRequestUri(route);
        Entity body = Entity.entity((Object)requestEntity, (String)"application/json");
        return this.executeRequest(correlationId, method, uri, "application/json", body);
    }

    protected <T> T execute(Class<T> type, String correlationId, String method, String route, Object requestEntity) throws ApplicationException {
        Response response = this.executeJsonRequest(correlationId, method, route, requestEntity);
        try {
            Object result = response.readEntity(type);
            return (T)result;
        }
        catch (Throwable ex) {
            throw new InvocationException(correlationId, "SERIALIZATION_FAILED", "Failed to deserialize HTTP response").withCause(ex);
        }
    }

    protected <T> T execute(GenericType<T> type, String correlationId, String method, String route, Object requestEntity) throws ApplicationException {
        Response response = this.executeJsonRequest(correlationId, method, route, requestEntity);
        try {
            Object result = response.readEntity(type);
            return (T)result;
        }
        catch (Throwable ex) {
            throw new InvocationException(correlationId, "SERIALIZATION_FAILED", "Failed to deserialize HTTP response").withCause(ex);
        }
    }
}

