/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.connect;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.pipservices.commons.config.ConfigParams;
import org.pipservices.commons.config.IConfigurable;
import org.pipservices.commons.errors.ApplicationException;
import org.pipservices.commons.errors.ConfigException;
import org.pipservices.commons.refer.IReferenceable;
import org.pipservices.commons.refer.IReferences;
import org.pipservices.components.connect.ConnectionParams;
import org.pipservices.components.connect.ConnectionResolver;

public class HttpConnectionResolver
implements IReferenceable,
IConfigurable {
    protected ConnectionResolver _connectionResolver = new ConnectionResolver();

    public void configure(ConfigParams config) {
        this._connectionResolver.configure(config);
    }

    public void setReferences(IReferences references) {
        this._connectionResolver.setReferences(references);
    }

    private void validateConnection(String correlationId, ConnectionParams connection) throws ApplicationException {
        if (connection == null) {
            throw new ConfigException(correlationId, "NO_CONNECTION", "HTTP connection is not set");
        }
        String uri = connection.getUri();
        if (uri != null && uri.length() > 0) {
            return;
        }
        String protocol = connection.getProtocol("http");
        if (!"http".equals(protocol)) {
            throw new ConfigException(correlationId, "WRONG_PROTOCOL", "Protocol is not supported by REST connection").withDetails("protocol", (Object)protocol);
        }
        String host = connection.getHost();
        if (host == null) {
            throw new ConfigException(correlationId, "NO_HOST", "Connection host is not set");
        }
        int port = connection.getPort();
        if (port == 0) {
            throw new ConfigException(correlationId, "NO_PORT", "Connection port is not set");
        }
    }

    private void updateConnection(ConnectionParams connection) {
        if (connection.getUri() == null || connection.getUri().length() == 0) {
            String uri = connection.getProtocol() + "://" + connection.getHost();
            if (connection.getPort() != 0) {
                uri = uri + ":" + connection.getPort();
            }
            connection.setUri(uri);
        } else {
            URI uri = UriBuilder.fromUri((String)connection.getUri()).build(new Object[0]);
            connection.setProtocol(uri.getScheme());
            connection.setHost(uri.getHost());
            connection.setPort(uri.getPort());
        }
    }

    public ConnectionParams resolve(String correlationId) throws ApplicationException {
        ConnectionParams connection = this._connectionResolver.resolve(correlationId);
        this.validateConnection(correlationId, connection);
        this.updateConnection(connection);
        return connection;
    }

    public List<ConnectionParams> resolveAll(String correlationId) throws ApplicationException {
        List connections = this._connectionResolver.resolveAll(correlationId);
        for (ConnectionParams connection : connections) {
            this.validateConnection(correlationId, connection);
            this.updateConnection(connection);
        }
        return connections;
    }

    public void register(String correlationId) throws ApplicationException {
        ConnectionParams connection = this._connectionResolver.resolve(correlationId);
        this.validateConnection(correlationId, connection);
        this._connectionResolver.register(correlationId, connection);
    }
}

