/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.services;

import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.pipservices.commons.commands.ICommand;
import org.pipservices.commons.commands.ICommandable;
import org.pipservices.commons.errors.ConfigException;
import org.pipservices.commons.refer.IReferences;
import org.pipservices.commons.refer.ReferenceException;
import org.pipservices.commons.run.Parameters;
import org.pipservices.components.count.Timing;
import org.pipservices.rpc.services.RestService;

public class CommandableHttpService
extends RestService {
    private ICommandable _controller;

    public CommandableHttpService(String baseRoute) {
        this._baseRoute = baseRoute;
        this._dependencyResolver.put("controller", (Object)"none");
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        super.setReferences(references);
        this._controller = (ICommandable)this._dependencyResolver.getOneRequired("controller");
    }

    @Override
    public void register() {
        if (this._controller == null) {
            return;
        }
        List commands = this._controller.getCommandSet().getCommands();
        for (final ICommand command : commands) {
            this.registerRoute("post", command.getName(), new Inflector<ContainerRequestContext, Response>(){

                public Response apply(ContainerRequestContext request) {
                    return CommandableHttpService.this.executeCommand(command, request);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response executeCommand(ICommand command, ContainerRequestContext request) {
        Response response;
        String json = this.getBodyAsString(request);
        Parameters parameters = json == null ? new Parameters() : Parameters.fromJson((String)json);
        String correlationId = this.getQueryParameter(request, "correlation_id");
        Timing timing = this.instrument(correlationId, this._baseRoute + '.' + command.getName());
        try {
            Object result = command.execute(correlationId, parameters);
            response = this.sendResult(result);
        }
        catch (Throwable throwable) {
            try {
                timing.endTiming();
                throw throwable;
            }
            catch (Exception ex) {
                return this.sendError(ex);
            }
        }
        timing.endTiming();
        return response;
    }
}

