/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.services;

import java.time.ZonedDateTime;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.pipservices.commons.config.ConfigParams;
import org.pipservices.commons.convert.StringConverter;
import org.pipservices.commons.errors.ConfigException;
import org.pipservices.rpc.services.RestService;

public class HeartbeatRestService
extends RestService {
    private String _route = "heartbeat";

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        super.configure(config);
        this._route = config.getAsStringWithDefault("route", this._route);
    }

    @Override
    public void register() {
        this.registerRoute("get", this._route, new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext request) {
                return HeartbeatRestService.this.heartbeat(request);
            }
        });
    }

    private Response heartbeat(ContainerRequestContext request) {
        String result = StringConverter.toString((Object)ZonedDateTime.now());
        return this.sendResult(result);
    }
}

