/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.services;

import com.sun.net.httpserver.HttpServer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.jdkhttp.JdkHttpServerFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.pipservices.commons.config.ConfigParams;
import org.pipservices.commons.config.IConfigurable;
import org.pipservices.commons.errors.ApplicationException;
import org.pipservices.commons.errors.ConfigException;
import org.pipservices.commons.errors.ConnectionException;
import org.pipservices.commons.refer.DependencyResolver;
import org.pipservices.commons.refer.IReferenceable;
import org.pipservices.commons.refer.IReferences;
import org.pipservices.commons.refer.ReferenceException;
import org.pipservices.commons.run.IOpenable;
import org.pipservices.components.connect.ConnectionParams;
import org.pipservices.components.count.CompositeCounters;
import org.pipservices.components.count.Timing;
import org.pipservices.components.log.CompositeLogger;
import org.pipservices.rpc.connect.HttpConnectionResolver;
import org.pipservices.rpc.services.IRegisterable;

public class HttpEndpoint
implements IOpenable,
IConfigurable,
IReferenceable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples((Object[])new Object[]{"connection.protocol", "http", "connection.host", "0.0.0.0", "connection.port", 3000, "options.request_max_size", 0x100000, "options.connect_timeout", 60000, "options.debug", true});
    protected HttpConnectionResolver _connectionResolver = new HttpConnectionResolver();
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected DependencyResolver _dependencyResolver = new DependencyResolver(_defaultConfig);
    private String _url;
    private HttpServer _server;
    private ResourceConfig _resources;
    private List<IRegisterable> _registrations = new ArrayList<IRegisterable>();

    public void configure(ConfigParams config) throws ConfigException {
        config = config.setDefaults(_defaultConfig);
        this._dependencyResolver.configure(config);
        this._connectionResolver.configure(config);
    }

    public void setReferences(IReferences references) throws ReferenceException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._dependencyResolver.setReferences(references);
        this._connectionResolver.setReferences(references);
    }

    protected Timing Instrument(String correlationId, String name) {
        this._logger.trace(correlationId, "Executing {0} method", new Object[]{name});
        return this._counters.beginTiming(name + ".exec_time");
    }

    public boolean isOpen() {
        return this._server != null;
    }

    public void open(String correlationId) throws ApplicationException {
        if (this.isOpen()) {
            return;
        }
        ConnectionParams connection = this._connectionResolver.resolve(correlationId);
        String protocol = connection.getProtocol("http");
        String host = connection.getHost();
        int port = connection.getPort();
        URI uri = UriBuilder.fromUri((String)(protocol + "://" + host)).port(port).path("/").build(new Object[0]);
        this._url = uri.toString();
        try {
            this._resources = new ResourceConfig();
            this.performRegistrations();
            this._server = JdkHttpServerFactory.createHttpServer((URI)uri, (ResourceConfig)this._resources);
            this._logger.info(correlationId, "Opened REST service at %s", new Object[]{this._url});
        }
        catch (Exception ex) {
            this._server = null;
            throw new ConnectionException(correlationId, "CANNOT_CONNECT", "Opening HTTP endpoint failed").wrap((Throwable)ex).withDetails("url", (Object)this._url);
        }
    }

    public void close(String correlationId) throws ApplicationException {
        if (this._server != null) {
            try {
                this._server.stop(0);
                this._logger.info(correlationId, "Closed HTTP endpoint at %s", new Object[]{this._url});
            }
            catch (Exception ex) {
                this._logger.warn(correlationId, "Failed while closing HTTP endpoint: %s", new Object[]{ex});
            }
            this._server = null;
            this._resources = null;
            this._url = null;
        }
    }

    private void performRegistrations() {
        for (IRegisterable registration : this._registrations) {
            registration.register();
        }
    }

    public void register(IRegisterable registration) {
        this._registrations.add(registration);
    }

    public void unregister(IRegisterable registration) {
        this._registrations.remove(registration);
    }

    public void registerRoute(String method, String route, Inflector<ContainerRequestContext, Response> action) {
        if (route.charAt(0) == '/') {
            route = route.substring(1);
        }
        Resource.Builder builder = Resource.builder().addChildResource(route);
        method = method.toUpperCase();
        builder.addMethod(method).handledBy(action);
        Resource resource = builder.build();
        this.registerResource(resource);
    }

    public void registerResource(Resource resource) {
        if (this._resources != null) {
            this._resources.registerResources(new Resource[]{resource});
        }
    }
}

