/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.services;

import javax.ws.rs.core.Response;
import org.pipservices.commons.errors.ApplicationException;
import org.pipservices.commons.errors.ErrorDescription;
import org.pipservices.commons.errors.ErrorDescriptionFactory;

public class HttpResponseSender {
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int NO_CONTENT = 204;
    private static final int CREATED = 201;
    private static final int OK = 200;

    public static Response sendError(Exception ex) {
        if (ex instanceof RuntimeException && ex.getStackTrace().length > 0) {
            ex.setStackTrace(new StackTraceElement[]{ex.getStackTrace()[0]});
        }
        try {
            if (ex instanceof ApplicationException) {
                ApplicationException ex3 = (ApplicationException)ex;
                ErrorDescription errorDesc3 = ErrorDescriptionFactory.create((ApplicationException)ex3);
                return Response.status((int)ex3.getStatus()).type("application/json").entity((Object)errorDesc3).build();
            }
            ErrorDescription errorDesc = ErrorDescriptionFactory.create((Throwable)ex, null);
            return Response.status((int)500).type("application/json").entity((Object)errorDesc).build();
        }
        catch (Exception ex2) {
            return Response.status((int)500).build();
        }
    }

    public static Response sendResult(Object result) {
        try {
            if (result == null) {
                return Response.status((int)204).build();
            }
            return Response.status((int)200).type("application/json").entity(result).build();
        }
        catch (Exception ex2) {
            return Response.status((int)500).build();
        }
    }

    public static Response sendEmptyResult() {
        return Response.status((int)204).build();
    }

    public static Response sendCreatedResult(Object result) {
        try {
            if (result == null) {
                return Response.status((int)204).build();
            }
            return Response.status((int)201).type("application/json").entity(result).build();
        }
        catch (Exception ex2) {
            return Response.status((int)500).build();
        }
    }

    public static Response sendDeletedResult(Object result) {
        try {
            if (result == null) {
                return Response.status((int)204).build();
            }
            return Response.status((int)200).type("application/json").entity(result).build();
        }
        catch (Exception ex2) {
            return Response.status((int)500).build();
        }
    }
}

