/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.services;

import java.util.Map;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.pipservices.commons.convert.StringConverter;
import org.pipservices.commons.data.FilterParams;
import org.pipservices.commons.data.PagingParams;

public class RestQueryParams
extends MultivaluedStringMap {
    private static final long serialVersionUID = -903917330561942092L;

    public RestQueryParams() {
    }

    public RestQueryParams(String correlationId) {
        this.addCorrelationId(correlationId);
    }

    public RestQueryParams(String correlationId, FilterParams filter, PagingParams paging) {
        this.addCorrelationId(correlationId);
        this.addFilterParams(filter);
        this.addPagingParams(paging);
    }

    public void addCorrelationId(String correlationId) {
        if (correlationId == null) {
            return;
        }
        this.add("correlation_id", correlationId);
    }

    public void addFilterParams(FilterParams filter) {
        if (filter == null) {
            return;
        }
        for (Map.Entry entry : filter.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            this.add(entry.getKey(), value);
        }
    }

    public void addPagingParams(PagingParams paging) {
        if (paging == null) {
            return;
        }
        if (paging.getSkip() != null) {
            this.add("skip", StringConverter.toString((Object)paging.getSkip()));
        }
        if (paging.getTake() != null) {
            this.add("take", StringConverter.toString((Object)paging.getTake()));
        }
        this.add("total", StringConverter.toString((Object)paging.hasTotal()));
    }
}

