/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.services;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.model.Resource;
import org.pipservices.commons.config.ConfigParams;
import org.pipservices.commons.config.IConfigurable;
import org.pipservices.commons.convert.JsonConverter;
import org.pipservices.commons.errors.ApplicationException;
import org.pipservices.commons.errors.ConfigException;
import org.pipservices.commons.errors.InvalidStateException;
import org.pipservices.commons.errors.InvocationException;
import org.pipservices.commons.refer.DependencyResolver;
import org.pipservices.commons.refer.IReferenceable;
import org.pipservices.commons.refer.IReferences;
import org.pipservices.commons.refer.IUnreferenceable;
import org.pipservices.commons.refer.ReferenceException;
import org.pipservices.commons.run.IOpenable;
import org.pipservices.components.count.CompositeCounters;
import org.pipservices.components.count.Timing;
import org.pipservices.components.log.CompositeLogger;
import org.pipservices.rpc.services.HttpEndpoint;
import org.pipservices.rpc.services.HttpResponseSender;
import org.pipservices.rpc.services.IRegisterable;

public abstract class RestService
implements IOpenable,
IConfigurable,
IReferenceable,
IUnreferenceable,
IRegisterable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples((Object[])new Object[]{"dependencies.endpoint", "pip-services:endpoint:http:*:1.0"});
    private ConfigParams _config;
    private IReferences _references;
    private boolean _localEndpoint;
    private boolean _opened;
    protected String _baseRoute;
    protected HttpEndpoint _endpoint;
    protected DependencyResolver _dependencyResolver = new DependencyResolver(_defaultConfig);
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected HttpServer _server;
    protected String _url;

    protected RestService() {
    }

    public void configure(ConfigParams config) throws ConfigException {
        this._config = config.setDefaults(_defaultConfig);
        this._dependencyResolver.configure(config);
        this._baseRoute = config.getAsStringWithDefault("base_route", this._baseRoute);
    }

    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._dependencyResolver.setReferences(references);
        this._references = references;
        this._endpoint = (HttpEndpoint)this._dependencyResolver.getOneOptional("endpoint");
        if (this._endpoint == null) {
            this._endpoint = this.createLocalEndpoint();
            this._localEndpoint = true;
        } else {
            this._localEndpoint = false;
        }
        this._endpoint.register(this);
    }

    public void unsetReferences() {
        if (this._endpoint != null) {
            this._endpoint.unregister(this);
            this._endpoint = null;
        }
    }

    private HttpEndpoint createLocalEndpoint() throws ConfigException, ReferenceException {
        HttpEndpoint endpoint = new HttpEndpoint();
        if (this._config != null) {
            endpoint.configure(this._config);
        }
        if (this._references != null) {
            endpoint.setReferences(this._references);
        }
        return endpoint;
    }

    protected Timing instrument(String correlationId, String name) {
        this._logger.trace(correlationId, "Executing %s method", new Object[]{name});
        return this._counters.beginTiming(name + ".exec_time");
    }

    public boolean isOpen() {
        return this._opened;
    }

    public void open(String correlationId) throws ApplicationException {
        if (this.isOpen()) {
            return;
        }
        if (this._endpoint == null) {
            this._endpoint = this.createLocalEndpoint();
            this._endpoint.register(this);
            this._localEndpoint = true;
        }
        if (this._localEndpoint) {
            this._endpoint.open(correlationId);
        }
        this._opened = true;
    }

    public void close(String correlationId) throws ApplicationException {
        if (!this._opened) {
            return;
        }
        if (this._endpoint == null) {
            throw new InvalidStateException(correlationId, "NO_ENDPOINT", "HTTP endpoint is missing");
        }
        if (this._localEndpoint) {
            this._endpoint.close(correlationId);
        }
        this._opened = false;
    }

    protected Response sendError(Exception ex) {
        return HttpResponseSender.sendError(ex);
    }

    protected Response sendResult(Object result) {
        return HttpResponseSender.sendResult(result);
    }

    protected Response sendEmptyResult() {
        return HttpResponseSender.sendEmptyResult();
    }

    protected Response sendCreatedResult(Object result) {
        return HttpResponseSender.sendCreatedResult(result);
    }

    protected Response sendDeleted(Object result) {
        return HttpResponseSender.sendDeletedResult(result);
    }

    protected String getQueryParameter(ContainerRequestContext request, String name) {
        try {
            name = URLEncoder.encode(name, "UTF-8");
            if (request.getUriInfo().getQueryParameters().containsKey((Object)name)) {
                String value = (String)request.getUriInfo().getQueryParameters().getFirst((Object)name);
                String string = value != null ? URLDecoder.decode(value, "UTF-8") : null;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    protected String getBodyAsString(ContainerRequestContext request) throws ApplicationException {
        try {
            InputStream streamReader = request.getEntityStream();
            byte[] data = new byte[streamReader.available()];
            streamReader.read(data, 0, data.length);
            String value = new String(data, "UTF-8");
            return value;
        }
        catch (IOException ex) {
            throw new InvocationException(null, "READ_ERROR", "Cannot read input stream").wrap((Throwable)ex);
        }
    }

    protected <T> T getBodyAsJson(Class<T> type, ContainerRequestContext request) throws ApplicationException {
        if (!request.getMediaType().toString().contains("application/json")) {
            throw new InvocationException(null, "EXPECTED_JSON", "Expected application/json media type");
        }
        String json = this.getBodyAsString(request);
        try {
            return (T)JsonConverter.fromJson(type, (String)json);
        }
        catch (IOException ex) {
            throw new InvocationException(null, "READ_ERROR", "Failed to deserialize request from JSON").wrap((Throwable)ex);
        }
    }

    protected void registerRoute(String method, String route, Inflector<ContainerRequestContext, Response> action) {
        if (this._endpoint == null) {
            return;
        }
        if (route.charAt(0) != '/') {
            route = "/" + route;
        }
        if (this._baseRoute != null && this._baseRoute.length() > 0) {
            String baseRoute = this._baseRoute;
            if (baseRoute.charAt(0) != '/') {
                baseRoute = "/" + baseRoute;
            }
            route = baseRoute + route;
        }
        this._endpoint.registerRoute(method, route, action);
    }

    protected void registerResource(Resource resource) {
        if (this._endpoint == null) {
            return;
        }
        this._endpoint.registerResource(resource);
    }
}

