/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.rpc.services;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.pipservices.commons.config.ConfigParams;
import org.pipservices.commons.convert.StringConverter;
import org.pipservices.commons.data.StringValueMap;
import org.pipservices.commons.errors.ConfigException;
import org.pipservices.commons.refer.Descriptor;
import org.pipservices.commons.refer.IReferences;
import org.pipservices.commons.refer.ReferenceException;
import org.pipservices.commons.run.Parameters;
import org.pipservices.components.info.ContextInfo;
import org.pipservices.rpc.services.RestService;

public class StatusRestService
extends RestService {
    private ZonedDateTime _startTime = ZonedDateTime.now();
    private IReferences _references;
    private ContextInfo _contextInfo;
    private String _route = "status";

    public StatusRestService() {
        this._dependencyResolver.put("context-info", (Object)new Descriptor("pip-services", "context-info", "default", "*", "1.0"));
    }

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        super.configure(config);
        this._route = config.getAsStringWithDefault("route", this._route);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._references = references;
        super.setReferences(references);
        this._contextInfo = (ContextInfo)this._dependencyResolver.getOneOptional("context-info");
    }

    @Override
    public void register() {
        this.registerRoute("get", this._route, new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext request) {
                return StatusRestService.this.status(request);
            }
        });
    }

    private Response status(ContainerRequestContext request) {
        String id = this._contextInfo != null ? this._contextInfo.getContextId() : "";
        String name = this._contextInfo != null ? this._contextInfo.getName() : "Unknown";
        String description = this._contextInfo != null ? this._contextInfo.getDescription() : "";
        long uptime = Duration.between(this._startTime, ZonedDateTime.now()).toMillis();
        StringValueMap properties = this._contextInfo.getProperties();
        ArrayList<String> components = new ArrayList<String>();
        if (this._references != null) {
            for (Object locator : this._references.getAllLocators()) {
                components.add(locator.toString());
            }
        }
        Parameters status = Parameters.fromTuples((Object[])new Object[]{"id", id, "name", name, "description", description, "start_time", StringConverter.toString((Object)this._startTime), "current_time", StringConverter.toString((Object)ZonedDateTime.now()), "uptime", uptime, "properties", properties, "components", components});
        return this.sendResult(status);
    }
}

