#!/usr/bin/env pwsh

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../../common/include.ps1"

# Get component metadata
$component = Read-Component -Path "$PSScriptRoot/../../../component.json"

# Verify build server and set environment variable
Set-EnvBuildServer

# Get build number from build server and update it in component file
if ($env:BUILD_SERVER -eq "gitlab") {
    $build = curl -s -f  --header "PRIVATE-TOKEN: $($env:GITLAB_TOKEN)" "$($env:GITLAB_URL)/api/v4/projects/$($env:CI_PROJECT_ID)/variables/BUILD_NUMBER" | ConvertFrom-Json
    $component.build = [int]$build.value + 1
    curl -s -f --request PUT --header "PRIVATE-TOKEN: $($env:GITLAB_TOKEN)" "$($env:GITLAB_URL)/api/v4/projects/$($env:CI_PROJECT_ID)/variables/BUILD_NUMBER" --form "value=$($component.build)"
} elseif ($env:BUILD_SERVER -eq "github" ) {
    $component.build = [int]$env:GITHUB_RUN_NUMBER
} elseif ($env:BUILD_SERVER -eq "jenkins") {
    $component.build = [int]$env:BUILD_NUMBER
} elseif ($env:BUILD_SERVER -eq "bitbucket") {
    $component.build = [int]$env:BITBUCKET_BUILD_NUMBER
}

# Save updated component metadata
Write-Component -Path "$PSScriptRoot/../../../component.json" -Component $component

Write-Host "Set build number to $($component.build)"
