#!/usr/bin/env pwsh

param
(
    [Parameter(Mandatory = $true, Position = 0)]
    [string] $Cluster,
    [Parameter(Mandatory = $true, Position = 1)]
    [string] $Namespace,
    [Parameter(Mandatory = $false, Position = 2)]
    [string] $Product,
    [Parameter(Mandatory = $false, Position = 3)]
    [string] $Baseline
)

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../../common/include.ps1"

# Get component metadata
$component = Read-Component -Path "$PSScriptRoot/../../../component.json"

# Set script params default values
if ($Product -eq "") {
    $Product = $Namespace
}
if ($Baseline -eq "") {
    $Baseline = "$Cluster`_$Product`_$((Get-Date).ToString("yyMMdd_HHmmss"))"
}

# Invoke baseline script
. "$PSScriptRoot/baseline_k8s_docker.ps1" $Cluster $Namespace $Product $Baseline

# Set baseline to component.json 
Write-Host "Saving baseline '$Baseline' to artifacts file."
if ($null -eq $component) {
    $component = @{
        baseline = $Baseline
    }
} else {
    $component | add-member -Name "baseline" -value $Baseline -MemberType NoteProperty

}

# Save updated component metadata
Write-Component -Path "$PSScriptRoot/../../../component.json" -Component $component
