#!/usr/bin/env pwsh

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../../common/include.ps1"

# Get component metadata
$component = Read-Component -Path "$PSScriptRoot/../../../component.json"

# Verify rollout status
kubectl rollout status deployment $component.name --timeout=5m
if ($LASTEXITCODE -ne 0) {
    # Rollback deployment
    kubectl rollout undo deployment $component.name 
    Write-Error "Deployment update failed. Rolling back $($component.name) deployment..."
} else {
    Write-Host "Deployment update successfull. Rollback skipped."
}
