function Update-S3Metrics {
    # Read pipelines metrics file
    aws s3 cp "s3://$AWSS3Bucket/$AWSS3BucketFolder/$Org`_latest_full.json" .

    if (Test-Path -Path "$Org`_latest_full.json") {
        $latestPipelines = Get-Content -Path "$Org`_latest_full.json" | ConvertFrom-Json
        $newPipeline = $True
        $newLatestPipelines = @()
        foreach ($pipeline in $latestPipelines) {
            if ($pipeline.name -eq $latestPipelineInfo.name) {
                $newLatestPipelines += $latestPipelineInfo
                $newPipeline = $False
            } else {
                $newLatestPipelines += $pipeline
            }
        }
        if ($newPipeline) {
            $newLatestPipelines += $latestPipelineInfo
        }
    } else {
        $newLatestPipelines = @($latestPipelineInfo)
    }

    # Calculate status of pipelines in group
    $nowFormated = Get-Date -Format u
    $pipelinesGroupStatus = @{
        "date" = $nowFormated
        "total" = 0
        "success" = 0
        "failed" = 0
        "builded" = 0
        "tested" = 0
        "packaged" = 0
        "published" = 0
    }

    foreach ($pipeline in $newLatestPipelines) {
        $pipelinesGroupStatus.total += 1
        if ($pipeline.status -eq "success") {
            $pipelinesGroupStatus.success += 1
        } else {
            $pipelinesGroupStatus.failed += 1
        }
        if ($pipeline.builded) {
            $pipelinesGroupStatus.builded += 1
        }
        if ($pipeline.tested) {
            $pipelinesGroupStatus.tested += 1
        }
        if ($pipeline.packaged) {
            $pipelinesGroupStatus.packaged += 1
        }
        if ($pipeline.published) {
            $pipelinesGroupStatus.published += 1
        }
    }

    # Calculate status of all repo groups in bucket
    # Download all status files from bucket
    aws s3 cp "s3://$AWSS3Bucket/$AWSS3BucketFolder/" . --recursive --exclude "*" --include "*_status.json" --exclude "total_status.json"

    $totalStatus = @{
        "date" = $nowFormated
        "total" = 0
        "success" = 0
        "failed" = 0
        "builded" = 0
        "tested" = 0
        "packaged" = 0
        "published" = 0
    }

    $statusFiles = Get-ChildItem -Recurse "*_status.json"
    # Check when no status files yet
    if ($statusFiles -eq $null) {
        $totalStatus = $pipelinesGroupStatus
    }
    foreach($statusFile in $statusFiles) {
        if ($statusFile.Name -ne "total_status.json") { #ignore total_status
            $status = Get-Content -Path $statusFile.Name | ConvertFrom-Json
            $totalStatus.total += $status.total
            $totalStatus.success += $status.success
            $totalStatus.failed += $status.failed
            $totalStatus.builded += $status.builded
            $totalStatus.tested += $status.tested
            $totalStatus.packaged += $status.packaged
            $totalStatus.published += $status.published
        }
    }

    # Save results to files
    ConvertTo-Json @($newLatestPipelines) | Set-Content -Path "$Org`_latest_full.json"
    $pipelinesGroupStatus | ConvertTo-Json | Set-Content -Path "$Org`_status.json"
    $totalStatus | ConvertTo-Json | Set-Content -Path "total_status.json"
    ConvertTo-Json @($jobsDuration) | Set-Content -Path "$name`_duration.json"

    # Process monorepo metrics
    $latestFileName = "$Org`_latest_full.json"
    $statusFileName = "$Org`_status.json"
    $durationFileName = "$name`_duration.json"
    if ($env:IS_MONOREPO) {
        # Load support functions
        . "$PSScriptRoot/../common/include.ps1"
        # Get component metadata
        $component = Read-Component -Path "$PSScriptRoot/../../component.json"
        
        $latestFileName = "$name`_latest_full.json"
        $statusFileName = "$name`_status.json"
        $durationFileName = "$($component.name)_duration.json"
    }

    # Upload to s3
    Write-Host "Uploading metrics json file to s3..."
    aws s3 cp "$Org`_latest_full.json" "s3://$AWSS3Bucket/$AWSS3BucketFolder/$latestFileName"
    aws s3 cp "$Org`_status.json" "s3://$AWSS3Bucket/$AWSS3BucketFolder/$statusFileName"
    aws s3 cp "total_status.json" "s3://$AWSS3Bucket/$AWSS3BucketFolder/total_status.json"
    aws s3 cp "$name`_duration.json" "s3://$AWSS3Bucket/$AWSS3BucketFolder/durations/$durationFileName"

    if ($LastExitCode -eq 0) {
        Write-Host "****************************************\n***  pipeline metrics uploaded to s3 ***\n****************************************"
    }
}