#!/usr/bin/env pwsh

### This script created to be executed only on build servers
### Ubuntu

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Load support functions
. "$PSScriptRoot/../../common/include.ps1"

# Get component metadata
$component = Read-Component -Path "$PSScriptRoot/../../../component.json"

Write-Host "Installing missing cli tools..."

# Install required cli tools
if (-not $(Resolve-CliTool "aws")) {
    Write-Host "Installing awscli..."
    sudo apt-get update
    sudo apt-get install -y awscli
}
if ($component.language -eq "node") {
    if (-not $(Resolve-CliTool "npm")) {
        Write-Host "Installing nodejs..."
        sudo apt-get update
        sudo apt install -y nodejs
    }
} elseif ($component.language -eq "dart") {
    if (-not $(Resolve-CliTool "dart")) {
        Write-Host "Installing libdart..."
        sudo apt-add-repository ppa:dartsim/ppa
        sudo apt-get install -y libdart6-dev
        sudo apt-get install -y libdart6-collision-bullet-dev
        sudo apt-get install -y libdart6-all-dev
    }
} elseif ($component.language -eq "dotnet") {
    if (-not $(Resolve-CliTool "dotnet")) {
        Write-Host "Installing dotnet-sdk..."
        sudo apt-get install -y apt-transport-https
        sudo apt-get update
        sudo apt-get install -y dotnet-sdk-6.0
    }
} elseif ($component.language -eq "java") {
    if (-not $(Resolve-CliTool "gpg")) {
        Write-Host "Installing gpg..."
        sudo apt-get install -y gpg
    }
    if (-not $(Resolve-CliTool "mvn")) {
        Write-Host "Installing maven..."
        sudo apt install -y maven 
    }
} elseif ($component.language -eq "python") {
    Write-Host "Installing dependecies to publish a python package..."
    python -m pip install --upgrade build
    python -m pip install --upgrade twine
}
